/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer.category;

import java.awt.Color;
import java.io.Serializable;
import org.jfree.chart3d.data.DataUtils;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.Values3D;
import org.jfree.chart3d.graphics3d.Offset3D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.label.CategoryItemLabelGenerator;
import org.jfree.chart3d.plot.CategoryPlot3D;
import org.jfree.chart3d.renderer.AbstractRenderer3D;
import org.jfree.chart3d.renderer.category.CategoryColorSource;
import org.jfree.chart3d.renderer.category.CategoryRenderer3D;
import org.jfree.chart3d.renderer.category.StandardCategoryColorSource;

public abstract class AbstractCategoryRenderer3D
extends AbstractRenderer3D
implements CategoryRenderer3D,
Serializable {
    private CategoryPlot3D plot;
    private CategoryColorSource colorSource = new StandardCategoryColorSource();
    private CategoryItemLabelGenerator itemLabelGenerator = null;
    private Offset3D itemLabelOffsets = new Offset3D(0.0, 0.05, 1.1);

    @Override
    public CategoryPlot3D getPlot() {
        return this.plot;
    }

    @Override
    public void setPlot(CategoryPlot3D plot) {
        this.plot = plot;
    }

    @Override
    public CategoryColorSource getColorSource() {
        return this.colorSource;
    }

    @Override
    public void setColorSource(CategoryColorSource colorSource) {
        Args.nullNotPermitted(colorSource, "colorSource");
        this.colorSource = colorSource;
        this.fireChangeEvent(true);
    }

    @Override
    public void setColors(Color ... colors) {
        this.setColorSource(new StandardCategoryColorSource(colors));
    }

    public CategoryItemLabelGenerator getItemLabelGenerator() {
        return this.itemLabelGenerator;
    }

    public void setItemLabelGenerator(CategoryItemLabelGenerator generator) {
        this.itemLabelGenerator = generator;
        this.fireChangeEvent(true);
    }

    public Offset3D getItemLabelOffsets() {
        return this.itemLabelOffsets;
    }

    public void setItemLabelOffsets(Offset3D offsets) {
        Args.nullNotPermitted(offsets, "offsets");
        this.itemLabelOffsets = offsets;
        this.fireChangeEvent(true);
    }

    @Override
    public Range findValueRange(Values3D<? extends Number> data) {
        return DataUtils.findValueRange(data);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCategoryRenderer3D)) {
            return false;
        }
        AbstractCategoryRenderer3D that = (AbstractCategoryRenderer3D)obj;
        if (!this.colorSource.equals(that.colorSource)) {
            return false;
        }
        if (!ObjectUtils.equals(this.itemLabelGenerator, that.itemLabelGenerator)) {
            return false;
        }
        if (!this.itemLabelOffsets.equals(that.itemLabelOffsets)) {
            return false;
        }
        return super.equals(obj);
    }
}

