/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.plot;

import java.awt.Font;
import java.io.Serializable;
import org.jfree.chart3d.data.DefaultKeyedValues;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.plot.FontSource;

public final class StandardFontSource<K extends Comparable<K>>
implements FontSource<K>,
Serializable {
    private static Font DEFAULT_FONT = new Font("Dialog", 0, 12);
    private DefaultKeyedValues<K, Font> fonts;
    private Font defaultFont;

    public StandardFontSource() {
        this(DEFAULT_FONT);
    }

    public StandardFontSource(Font defaultFont) {
        Args.nullNotPermitted(defaultFont, "defaultFont");
        this.defaultFont = defaultFont;
        this.fonts = new DefaultKeyedValues();
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.defaultFont = font;
    }

    @Override
    public Font getFont(K key) {
        Font result = this.fonts.getValue(key);
        if (result != null) {
            return result;
        }
        return this.defaultFont;
    }

    @Override
    public void setFont(K key, Font font) {
        if (font != null) {
            this.fonts.put(key, font);
        } else {
            this.fonts.remove(key);
        }
    }

    @Override
    public void style(Font font) {
        Args.nullNotPermitted(font, "font");
        this.defaultFont = font;
        this.fonts.clear();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardFontSource)) {
            return false;
        }
        StandardFontSource that = (StandardFontSource)obj;
        if (!this.defaultFont.equals(that.defaultFont)) {
            return false;
        }
        return this.fonts.equals(that.fonts);
    }
}

