/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.axis.Axis3DChangeEvent;
import org.jfree.chart3d.axis.Axis3DChangeListener;
import org.jfree.chart3d.axis.CategoryAxis3D;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.Dataset3DChangeEvent;
import org.jfree.chart3d.data.ItemKey;
import org.jfree.chart3d.data.KeyedValues3DItemKey;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.graphics3d.Dimension3D;
import org.jfree.chart3d.graphics3d.World;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.label.CategoryItemLabelGenerator;
import org.jfree.chart3d.label.CategoryLabelGenerator;
import org.jfree.chart3d.label.StandardCategoryItemLabelGenerator;
import org.jfree.chart3d.label.StandardCategoryLabelGenerator;
import org.jfree.chart3d.legend.LegendItemInfo;
import org.jfree.chart3d.legend.StandardLegendItemInfo;
import org.jfree.chart3d.plot.AbstractPlot3D;
import org.jfree.chart3d.renderer.Renderer3DChangeEvent;
import org.jfree.chart3d.renderer.Renderer3DChangeListener;
import org.jfree.chart3d.renderer.category.CategoryRenderer3D;

public class CategoryPlot3D
extends AbstractPlot3D
implements Axis3DChangeListener,
Renderer3DChangeListener,
Serializable {
    private static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 1, 1, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
    private CategoryDataset3D dataset;
    private CategoryRenderer3D renderer;
    private CategoryAxis3D rowAxis;
    private CategoryAxis3D columnAxis;
    private ValueAxis3D valueAxis;
    private boolean gridlinesVisibleForRows;
    private transient Paint gridlinePaintForRows;
    private transient Stroke gridlineStrokeForRows;
    private boolean gridlinesVisibleForColumns;
    private transient Paint gridlinePaintForColumns;
    private transient Stroke gridlineStrokeForColumns;
    private boolean gridlinesVisibleForValues;
    private transient Paint gridlinePaintForValues;
    private transient Stroke gridlineStrokeForValues;
    private CategoryLabelGenerator legendLabelGenerator;
    private Double yDimensionOverride;
    private CategoryItemLabelGenerator toolTipGenerator;

    public CategoryPlot3D(CategoryDataset3D dataset, CategoryRenderer3D renderer, CategoryAxis3D rowAxis, CategoryAxis3D columnAxis, ValueAxis3D valueAxis) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(renderer, "renderer");
        Args.nullNotPermitted(rowAxis, "rowAxis");
        Args.nullNotPermitted(columnAxis, "columnAxis");
        Args.nullNotPermitted(valueAxis, "valueAxis");
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.dimensions = this.calculateDimensions();
        this.renderer = renderer;
        this.renderer.setPlot(this);
        this.renderer.addChangeListener(this);
        this.rowAxis = rowAxis;
        this.rowAxis.addChangeListener(this);
        this.columnAxis = columnAxis;
        this.columnAxis.addChangeListener(this);
        this.valueAxis = valueAxis;
        this.valueAxis.addChangeListener(this);
        this.rowAxis.configureAsRowAxis(this);
        this.columnAxis.configureAsColumnAxis(this);
        this.valueAxis.configureAsValueAxis(this);
        this.gridlinesVisibleForValues = true;
        this.gridlinesVisibleForColumns = false;
        this.gridlinesVisibleForRows = false;
        this.gridlinePaintForRows = Color.WHITE;
        this.gridlinePaintForColumns = Color.WHITE;
        this.gridlinePaintForValues = Color.WHITE;
        this.gridlineStrokeForRows = DEFAULT_GRIDLINE_STROKE;
        this.gridlineStrokeForColumns = DEFAULT_GRIDLINE_STROKE;
        this.gridlineStrokeForValues = DEFAULT_GRIDLINE_STROKE;
        this.legendLabelGenerator = new StandardCategoryLabelGenerator();
        this.yDimensionOverride = null;
        this.toolTipGenerator = new StandardCategoryItemLabelGenerator();
    }

    public void setAutoAdjustDimensions(boolean auto) {
        this.autoAdjustDimensions = auto;
        if (auto) {
            this.dimensions = this.calculateDimensions();
            this.fireChangeEvent(true);
        }
    }

    public void setDimensions(Dimension3D dimensions) {
        Args.nullNotPermitted(dimensions, "dimensions");
        this.dimensions = dimensions;
        this.autoAdjustDimensions = false;
        this.fireChangeEvent(true);
    }

    public CategoryDataset3D getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset3D dataset) {
        Args.nullNotPermitted(dataset, "dataset");
        this.dataset.removeChangeListener(this);
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.datasetChanged(new Dataset3DChangeEvent(this, this.dataset));
    }

    public CategoryRenderer3D getRenderer() {
        return this.renderer;
    }

    public void setRenderer(CategoryRenderer3D renderer) {
        Args.nullNotPermitted(renderer, "renderer");
        this.renderer.removeChangeListener(this);
        this.renderer = renderer;
        this.renderer.addChangeListener(this);
        this.valueAxis.configureAsValueAxis(this);
        this.fireChangeEvent(true);
    }

    public CategoryAxis3D getRowAxis() {
        return this.rowAxis;
    }

    public void setRowAxis(CategoryAxis3D axis) {
        Args.nullNotPermitted(axis, "axis");
        this.rowAxis.removeChangeListener(this);
        this.rowAxis = axis;
        this.rowAxis.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public CategoryAxis3D getColumnAxis() {
        return this.columnAxis;
    }

    public void setColumnAxis(CategoryAxis3D axis) {
        Args.nullNotPermitted(axis, "axis");
        this.columnAxis.removeChangeListener(this);
        this.columnAxis = axis;
        this.columnAxis.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public ValueAxis3D getValueAxis() {
        return this.valueAxis;
    }

    public void setValueAxis(ValueAxis3D axis) {
        Args.nullNotPermitted(axis, "axis");
        this.valueAxis.removeChangeListener(this);
        this.valueAxis = axis;
        this.valueAxis.configureAsValueAxis(this);
        this.valueAxis.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public boolean getGridlinesVisibleForRows() {
        return this.gridlinesVisibleForRows;
    }

    public void setGridlinesVisibleForRows(boolean visible) {
        this.gridlinesVisibleForRows = visible;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintForRows() {
        return this.gridlinePaintForRows;
    }

    public void setGridlinePaintForRows(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.gridlinePaintForRows = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeForRows() {
        return this.gridlineStrokeForRows;
    }

    public void setGridlineStrokeForRows(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeForRows = stroke;
        this.fireChangeEvent(false);
    }

    public boolean getGridlinesVisibleForColumns() {
        return this.gridlinesVisibleForColumns;
    }

    public void setGridlinesVisibleForColumns(boolean visible) {
        this.gridlinesVisibleForColumns = visible;
        this.fireChangeEvent(false);
    }

    public boolean getGridlinesVisibleForValues() {
        return this.gridlinesVisibleForValues;
    }

    public void setGridlinesVisibleForValues(boolean visible) {
        this.gridlinesVisibleForValues = visible;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintForValues() {
        return this.gridlinePaintForValues;
    }

    public void setGridlinePaintForValues(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.gridlinePaintForValues = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeForValues() {
        return this.gridlineStrokeForValues;
    }

    public void setGridlineStrokeForValues(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeForValues = stroke;
        this.fireChangeEvent(false);
    }

    public Paint getGridlinePaintForColumns() {
        return this.gridlinePaintForColumns;
    }

    public void setGridlinePaintForColumns(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.gridlinePaintForColumns = paint;
        this.fireChangeEvent(false);
    }

    public Stroke getGridlineStrokeForColumns() {
        return this.gridlineStrokeForColumns;
    }

    public void setGridlineStrokeForColumns(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.gridlineStrokeForColumns = stroke;
        this.fireChangeEvent(false);
    }

    public CategoryLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(CategoryLabelGenerator generator) {
        Args.nullNotPermitted(generator, "generator");
        this.legendLabelGenerator = generator;
        this.fireChangeEvent(false);
    }

    public Double getYDimensionOverride() {
        return this.yDimensionOverride;
    }

    public void setYDimensionOverride(Double dim) {
        this.yDimensionOverride = dim;
        if (this.autoAdjustDimensions) {
            this.dimensions = this.calculateDimensions();
            this.fireChangeEvent(true);
        }
    }

    public CategoryItemLabelGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryItemLabelGenerator generator) {
        this.toolTipGenerator = generator;
        this.fireChangeEvent(false);
    }

    @Override
    public List<LegendItemInfo> getLegendInfo() {
        ArrayList<LegendItemInfo> result = new ArrayList<LegendItemInfo>();
        List keys = this.dataset.getSeriesKeys();
        for (Comparable key : keys) {
            int series = this.dataset.getSeriesIndex(key);
            Color color = this.renderer.getColorSource().getLegendColor(series);
            String seriesLabel = this.legendLabelGenerator.generateSeriesLabel(this.dataset, key);
            StandardLegendItemInfo info = new StandardLegendItemInfo(key, seriesLabel, color);
            result.add(info);
        }
        return result;
    }

    @Override
    public void compose(World world, double xOffset, double yOffset, double zOffset) {
        for (int series = 0; series < this.dataset.getSeriesCount(); ++series) {
            for (int row = 0; row < this.dataset.getRowCount(); ++row) {
                for (int column = 0; column < this.dataset.getColumnCount(); ++column) {
                    this.renderer.composeItem(this.dataset, series, row, column, world, this.getDimensions(), xOffset, yOffset, zOffset);
                }
            }
        }
    }

    @Override
    public String generateToolTipText(ItemKey itemKey) {
        if (!(itemKey instanceof KeyedValues3DItemKey)) {
            throw new IllegalArgumentException("The itemKey must be a Values3DItemKey instance.");
        }
        KeyedValues3DItemKey vik = (KeyedValues3DItemKey)itemKey;
        return this.toolTipGenerator.generateItemLabel(this.dataset, (Comparable<?>)vik.getSeriesKey(), (Comparable<?>)vik.getRowKey(), (Comparable<?>)vik.getColumnKey());
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        this.columnAxis.receive(visitor);
        this.rowAxis.receive(visitor);
        this.valueAxis.receive(visitor);
        this.renderer.receive(visitor);
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CategoryPlot3D)) {
            return false;
        }
        CategoryPlot3D that = (CategoryPlot3D)obj;
        if (this.gridlinesVisibleForRows != that.gridlinesVisibleForRows) {
            return false;
        }
        if (!this.gridlineStrokeForRows.equals(that.gridlineStrokeForRows)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintForRows, that.gridlinePaintForRows)) {
            return false;
        }
        if (this.gridlinesVisibleForColumns != that.gridlinesVisibleForColumns) {
            return false;
        }
        if (!this.gridlineStrokeForColumns.equals(that.gridlineStrokeForColumns)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintForColumns, that.gridlinePaintForColumns)) {
            return false;
        }
        if (this.gridlinesVisibleForValues != that.gridlinesVisibleForValues) {
            return false;
        }
        if (!this.gridlineStrokeForValues.equals(that.gridlineStrokeForValues)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.gridlinePaintForValues, that.gridlinePaintForValues)) {
            return false;
        }
        if (!this.legendLabelGenerator.equals(that.legendLabelGenerator)) {
            return false;
        }
        if (!ObjectUtils.equals(this.yDimensionOverride, that.yDimensionOverride)) {
            return false;
        }
        if (!ObjectUtils.equals(this.toolTipGenerator, that.toolTipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public void datasetChanged(Dataset3DChangeEvent event) {
        if (this.autoAdjustDimensions) {
            this.dimensions = this.calculateDimensions();
        }
        this.columnAxis.configureAsColumnAxis(this);
        this.rowAxis.configureAsRowAxis(this);
        this.valueAxis.configureAsValueAxis(this);
        super.datasetChanged(event);
    }

    private Dimension3D calculateDimensions() {
        double depth = Math.max(1.0, (double)(this.dataset.getRowCount() + 1));
        double width = Math.max(1.0, (double)(this.dataset.getColumnCount() + 1));
        double height = Math.max(1.0, Math.min(width, depth));
        if (this.yDimensionOverride != null) {
            height = this.yDimensionOverride;
        }
        return new Dimension3D(width, height, depth);
    }

    @Override
    public void axisChanged(Axis3DChangeEvent event) {
        this.fireChangeEvent(event.requiresWorldUpdate());
    }

    @Override
    public void rendererChanged(Renderer3DChangeEvent event) {
        this.fireChangeEvent(event.requiresWorldUpdate());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.gridlinePaintForRows, stream);
        SerialUtils.writePaint(this.gridlinePaintForColumns, stream);
        SerialUtils.writePaint(this.gridlinePaintForValues, stream);
        SerialUtils.writeStroke(this.gridlineStrokeForRows, stream);
        SerialUtils.writeStroke(this.gridlineStrokeForColumns, stream);
        SerialUtils.writeStroke(this.gridlineStrokeForValues, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.gridlinePaintForRows = SerialUtils.readPaint(stream);
        this.gridlinePaintForColumns = SerialUtils.readPaint(stream);
        this.gridlinePaintForValues = SerialUtils.readPaint(stream);
        this.gridlineStrokeForRows = SerialUtils.readStroke(stream);
        this.gridlineStrokeForColumns = SerialUtils.readStroke(stream);
        this.gridlineStrokeForValues = SerialUtils.readStroke(stream);
    }
}

