/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.legend;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.Orientation;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.graphics2d.Fit2D;
import org.jfree.chart3d.graphics2d.TextAnchor;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.TextUtils;
import org.jfree.chart3d.renderer.ColorScale;
import org.jfree.chart3d.table.AbstractTableElement;
import org.jfree.chart3d.table.ElementDimension;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;
import org.jfree.chart3d.table.TableElementVisitor;

public class ColorScaleElement
extends AbstractTableElement
implements TableElement {
    private final ColorScale scale;
    private final Orientation orientation;
    private final double barLength;
    private final double barWidth;
    private final double textOffset;
    private final Font font;
    private final Color textColor;
    private final NumberFormat formatter;

    public ColorScaleElement(ColorScale scale, Orientation orientation, double barWidth, double barLength, Font font, Color textColor) {
        Args.nullNotPermitted(scale, "scale");
        Args.nullNotPermitted((Object)orientation, "orientation");
        Args.nullNotPermitted(font, "font");
        this.scale = scale;
        this.orientation = orientation;
        this.barWidth = barWidth;
        this.barLength = barLength;
        this.textOffset = 2.0;
        this.font = font;
        this.textColor = textColor;
        this.formatter = new DecimalFormat("0.00");
    }

    public ColorScale getColorScale() {
        return this.scale;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public double getBarLength() {
        return this.barLength;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    @Override
    public void receive(TableElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds) {
        return this.preferredSize(g2, bounds, null);
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        double h;
        double w;
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        Range r = this.scale.getRange();
        String minStr = this.formatter.format(r.getMin());
        String maxStr = this.formatter.format(r.getMax());
        Rectangle2D minStrBounds = TextUtils.getTextBounds(minStr, fm);
        Rectangle2D maxStrBounds = TextUtils.getTextBounds(maxStr, fm);
        double maxStrWidth = Math.max(minStrBounds.getWidth(), maxStrBounds.getWidth());
        Insets insets = this.getInsets();
        if (this.orientation == Orientation.HORIZONTAL) {
            w = Math.min(this.barLength + (double)insets.left + (double)insets.right, bounds.getWidth());
            h = Math.min((double)insets.top + this.barWidth + this.textOffset + minStrBounds.getHeight() + (double)insets.bottom, bounds.getHeight());
        } else {
            w = Math.min((double)insets.left + this.barWidth + this.textOffset + maxStrWidth + (double)insets.right, bounds.getWidth());
            h = Math.min((double)insets.top + this.barLength + this.textOffset + minStrBounds.getHeight() + (double)insets.bottom, bounds.getHeight());
        }
        return new ElementDimension(w, h);
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(1);
        Dimension2D prefDim = this.preferredSize(g2, bounds);
        Fit2D fitter = Fit2D.getNoScalingFitter(this.getRefPoint());
        Rectangle2D dest = fitter.fit(prefDim, bounds);
        result.add(dest);
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw(this, g2, bounds);
        }
        Shape savedClip = g2.getClip();
        g2.clip(bounds);
        List<Rectangle2D> layoutInfo = this.layoutElements(g2, bounds, null);
        Rectangle2D dest = layoutInfo.get(0);
        if (this.getBackground() != null) {
            this.getBackground().fill(g2, dest);
        }
        g2.setFont(this.font);
        FontMetrics fm = g2.getFontMetrics();
        Range r = this.scale.getRange();
        String minStr = this.formatter.format(r.getMin());
        String maxStr = this.formatter.format(r.getMax());
        Rectangle2D minStrBounds = TextUtils.getTextBounds(minStr, fm);
        Rectangle2D maxStrBounds = TextUtils.getTextBounds(maxStr, fm);
        Insets insets = this.getInsets();
        if (this.orientation == Orientation.HORIZONTAL) {
            double x0 = dest.getX() + (double)insets.left + minStrBounds.getWidth() / 2.0;
            double x1 = dest.getMaxX() - (double)insets.right - maxStrBounds.getWidth() / 2.0;
            double y0 = dest.getY() + (double)insets.top;
            double y1 = y0 + this.barWidth;
            this.drawHorizontalScale(this.scale, g2, new Rectangle2D.Double((int)x0, (int)y0, (int)(x1 - x0), (int)this.barWidth));
            g2.setPaint(this.textColor);
            TextUtils.drawAlignedString(minStr, g2, (float)x0, (float)(y1 + this.textOffset), TextAnchor.TOP_CENTER);
            TextUtils.drawAlignedString(maxStr, g2, (float)x1, (float)(y1 + this.textOffset), TextAnchor.TOP_CENTER);
        } else {
            double maxStrWidth = Math.max(minStrBounds.getWidth(), maxStrBounds.getWidth());
            double x1 = dest.getMaxX() - (double)insets.right - maxStrWidth - this.textOffset;
            double x0 = x1 - this.barWidth;
            double y0 = dest.getY() + (double)insets.top + maxStrBounds.getHeight() / 2.0;
            double y1 = y0 + this.barLength;
            this.drawVerticalScale(this.scale, g2, new Rectangle2D.Double((int)x0, (int)y0, (int)(x1 - x0), (int)this.barLength));
            g2.setPaint(this.textColor);
            TextUtils.drawAlignedString(minStr, g2, (float)(x1 + this.textOffset), (float)y1, TextAnchor.HALF_ASCENT_LEFT);
            TextUtils.drawAlignedString(maxStr, g2, (float)(x1 + this.textOffset), (float)y0, TextAnchor.HALF_ASCENT_LEFT);
        }
        g2.setClip(savedClip);
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw(this, g2, bounds);
        }
    }

    private void drawHorizontalScale(ColorScale colorScale, Graphics2D g2, Rectangle2D bounds) {
        g2.setStroke(new BasicStroke(1.0f));
        int x = (int)bounds.getX();
        while ((double)x < bounds.getMaxX()) {
            double p = ((double)x - bounds.getX()) / bounds.getWidth();
            double value = colorScale.getRange().value(p);
            g2.setColor(colorScale.valueToColor(value));
            g2.drawLine(x, (int)bounds.getMinY(), x, (int)bounds.getMaxY());
            ++x;
        }
    }

    private void drawVerticalScale(ColorScale colorScale, Graphics2D g2, Rectangle2D bounds) {
        g2.setStroke(new BasicStroke(1.0f));
        int y = (int)bounds.getY();
        while ((double)y < bounds.getMaxY()) {
            double p = ((double)y - bounds.getY()) / bounds.getHeight();
            double value = colorScale.getRange().value(1.0 - p);
            g2.setColor(this.scale.valueToColor(value));
            g2.drawLine((int)bounds.getX(), y, (int)bounds.getMaxX(), y);
            ++y;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColorScaleElement)) {
            return false;
        }
        ColorScaleElement that = (ColorScaleElement)obj;
        if (!this.scale.equals(that.scale)) {
            return false;
        }
        if (!this.orientation.equals((Object)that.orientation)) {
            return false;
        }
        if (this.barLength != that.barLength) {
            return false;
        }
        if (this.barWidth != that.barWidth) {
            return false;
        }
        if (!this.font.equals(that.font)) {
            return false;
        }
        return super.equals(obj);
    }
}

