/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.label;

import java.io.Serializable;
import java.util.Formatter;
import org.jfree.chart3d.data.DataUtils;
import org.jfree.chart3d.data.PieDataset3D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.label.PieLabelGenerator;

public class StandardPieLabelGenerator
implements PieLabelGenerator,
Serializable {
    public static final String KEY_ONLY_TEMPLATE = "%s";
    public static final String PERCENT_TEMPLATE = "%s (%3$,.0f%%)";
    public static final String PERCENT_TEMPLATE_2DP = "%s (%3$,.2f%%)";
    public static final String VALUE_TEMPLATE = "%s (%2$,.0f)";
    public static final String VALUE_TEMPLATE_2DP = "%s (%2$,.2f)";
    public static final String DEFAULT_TEMPLATE = "%s (%3$,.0f%%)";
    private String template;

    public StandardPieLabelGenerator() {
        this("%s (%3$,.0f%%)");
    }

    public StandardPieLabelGenerator(String template) {
        Args.nullNotPermitted(template, "template");
        this.template = template;
    }

    @Override
    public String generateLabel(PieDataset3D dataset, Comparable<?> key) {
        Args.nullNotPermitted(dataset, "dataset");
        Args.nullNotPermitted(key, "key");
        Formatter formatter = new Formatter(new StringBuilder());
        Number value = (Number)dataset.getValue(key);
        Double percent = Double.NaN;
        if (value != null) {
            double total = DataUtils.total(dataset);
            percent = 100.0 * value.doubleValue() / total;
        }
        formatter.format(this.template, key, value, percent);
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardPieLabelGenerator)) {
            return false;
        }
        StandardPieLabelGenerator that = (StandardPieLabelGenerator)obj;
        return this.template.equals(that.template);
    }

    public int hashCode() {
        return this.template.hashCode();
    }
}

