/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.internal;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import org.jfree.chart3d.Chart3DHints;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;

public class OnDrawHandler
implements TableElementOnDraw {
    private final RenderingInfo info;
    boolean elementHinting;

    public OnDrawHandler(RenderingInfo info, boolean elementHinting) {
        this.info = info;
        this.elementHinting = elementHinting;
    }

    @Override
    public void beforeDraw(TableElement element, Graphics2D g2, Rectangle2D bounds) {
        InteractiveElementType t = (InteractiveElementType)((Object)element.getProperty("class"));
        if (t != null && this.info != null) {
            switch (t) {
                case TITLE: 
                case SUBTITLE: {
                    RenderedElement re = new RenderedElement((Object)t, bounds);
                    this.info.addElement(re);
                    break;
                }
                case LEGEND_ITEM: {
                    RenderedElement legendItemRE = new RenderedElement((Object)InteractiveElementType.LEGEND_ITEM, bounds);
                    legendItemRE.setProperty("series_key", element.getProperty("series_key"));
                    this.info.addElement(legendItemRE);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        if (t != null && this.elementHinting) {
            HashMap<String, String> m = new HashMap<String, String>();
            switch (t) {
                case TITLE: {
                    m.put("ref", "{\"type\": \"title\"}");
                    g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
                    break;
                }
                case SUBTITLE: {
                    m.put("ref", "{\"type\": \"subtitle\"}");
                    g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
                    break;
                }
                case LEGEND_ITEM: {
                    m.put("ref", this.generateLegendItemRef(element));
                    g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    @Override
    public void afterDraw(TableElement element, Graphics2D g2, Rectangle2D bounds) {
        if (!this.elementHinting) {
            return;
        }
        InteractiveElementType t = (InteractiveElementType)((Object)element.getProperty("class"));
        if (t == null) {
            return;
        }
        switch (t) {
            case TITLE: 
            case SUBTITLE: 
            case LEGEND_ITEM: {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, Boolean.TRUE);
                break;
            }
            default: {
                throw new RuntimeException("Seeing type " + t);
            }
        }
    }

    private String generateLegendItemRef(TableElement element) {
        Object key = element.getProperty("series_key");
        return "{\"type\": \"legendItem\", \"seriesKey\": \"" + key.toString() + "\"}";
    }
}

