/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.internal;

public final class Args {
    private Args() {
    }

    public static void nullNotPermitted(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException("Null '" + name + "' argument.");
        }
    }

    public static void negativeNotPermitted(double value, String name) {
        if (value < 0.0) {
            throw new IllegalArgumentException("Param '" + name + "' cannot be negative");
        }
    }

    public static void positiveRequired(double value, String name) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Param '" + name + "' must be positive.");
        }
    }

    public static void finiteRequired(double value, String name) {
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Param '" + name + "' must be finite.");
        }
    }

    public static void finitePositiveRequired(double value, String name) {
        if (value <= 0.0 || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Param '" + name + "' must be finite and positive.");
        }
    }

    public static void checkArrayBounds(int index, String name, int arrayLimit) {
        if (index >= arrayLimit) {
            throw new IllegalArgumentException("Requires '" + name + "' in the range 0 to " + (arrayLimit - 1));
        }
    }
}

