/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.jfree.chart3d.Resources;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.graphics3d.swing.Panel3D;

public class ZoomOutAction
extends AbstractAction {
    private final Panel3D panel;
    private double zoomMultiplier;

    public ZoomOutAction(Panel3D panel, boolean fontAwesome) {
        super("\uf010");
        this.panel = panel;
        this.zoomMultiplier = 1.0526315789473684;
        if (!fontAwesome) {
            this.putValue("Name", Resources.localString("ZOOM_OUT"));
        }
        this.putValue("ActionCommandKey", "ZOOM_OUT");
        this.putValue("ShortDescription", Resources.localString("ZOOM_OUT"));
    }

    public double getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    public void setZoomMultiplier(double multiplier) {
        this.zoomMultiplier = multiplier;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewPoint3D viewPt = this.panel.getViewPoint();
        double minDistance = this.panel.getMinViewingDistance();
        double maxDistance = minDistance * this.panel.getMaxViewingDistanceMultiplier();
        double valRho = Math.max(minDistance, Math.min(maxDistance, viewPt.getRho() * this.zoomMultiplier));
        this.panel.getViewPoint().setRho(valRho);
        this.panel.repaint();
    }
}

