/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d.internal;

import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Utils2D {
    private Utils2D() {
    }

    public static boolean spans(double value, double bound1, double bound2) {
        return bound1 < value && bound2 > value || bound1 > value && bound2 < value;
    }

    public static double area2(Point2D a, Point2D b, Point2D c) {
        double ax = a.getX();
        double ay = a.getY();
        double bx = b.getX();
        double by = b.getY();
        double cx = c.getX();
        double cy = c.getY();
        return (ax - cx) * (by - cy) - (ay - cy) * (bx - cx);
    }

    public static Point2D centerPoint(Point2D pt0, Point2D pt1, Point2D pt2, Point2D pt3) {
        float x = (float)((pt0.getX() + pt1.getX() + pt2.getX() + pt3.getX()) / 4.0);
        float y = (float)((pt0.getY() + pt1.getY() + pt2.getY() + pt3.getY()) / 4.0);
        return new Point2D.Float(x, y);
    }

    public static Dimension findDimension(Point2D[] pts) {
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (Point2D pt : pts) {
            minx = Math.min(minx, pt.getX());
            maxx = Math.max(maxx, pt.getX());
            miny = Math.min(miny, pt.getY());
            maxy = Math.max(maxy, pt.getY());
        }
        return new Dimension((int)(maxx - minx), (int)(maxy - miny));
    }

    public static Line2D createPerpendicularLine(Line2D line, double b, double size, Point2D opposingPoint) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double length = Math.sqrt(dx * dx + dy * dy);
        double pdx = dy / length;
        double pdy = -dx / length;
        int ccw = line.relativeCCW(opposingPoint);
        Point2D.Double pt1 = new Point2D.Double(line.getX1() + b * dx, line.getY1() + b * dy);
        Point2D.Double pt2 = new Point2D.Double(((Point2D)pt1).getX() - (double)ccw * size * pdx, ((Point2D)pt1).getY() - (double)ccw * size * pdy);
        return new Line2D.Double(pt1, pt2);
    }

    public static Line2D createPerpendicularLine(Line2D line, Point2D pt1, double size, Point2D opposingPoint) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        double length = Math.sqrt(dx * dx + dy * dy);
        double pdx = dy / length;
        double pdy = -dx / length;
        int ccw = line.relativeCCW(opposingPoint);
        Point2D.Double pt2 = new Point2D.Double(pt1.getX() - (double)ccw * size * pdx, pt1.getY() - (double)ccw * size * pdy);
        return new Line2D.Double(pt1, pt2);
    }

    public static double calculateTheta(Line2D line) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        return Math.atan2(dy, dx);
    }

    public static double length(Line2D line) {
        double dx = line.getX2() - line.getX1();
        double dy = line.getY2() - line.getY1();
        return Math.sqrt(dx * dx + dy * dy);
    }
}

