/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d;

import java.io.Serializable;
import org.jfree.chart3d.graphics3d.Point3D;

public class Rotate3D
implements Serializable {
    Point3D a;
    Point3D b;
    double angle;
    double r11;
    double r12;
    double r13;
    double r21;
    double r22;
    double r23;
    double r31;
    double r32;
    double r33;
    double r41;
    double r42;
    double r43;

    public Rotate3D(Point3D a, Point3D b, double angle) {
        this.a = a;
        this.b = b;
        this.angle = angle;
        double v1 = b.x - a.x;
        double v2 = b.y - a.y;
        double v3 = b.z - a.z;
        double theta = Math.atan2(v2, v1);
        double phi = Math.atan2(Math.sqrt(v1 * v1 + v2 * v2), v3);
        this.initRotate(a, theta, phi, angle);
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        double v1 = this.b.x - this.a.x;
        double v2 = this.b.y - this.a.y;
        double v3 = this.b.z - this.a.z;
        double theta = Math.atan2(v2, v1);
        double phi = Math.atan2(Math.sqrt(v1 * v1 + v2 * v2), v3);
        this.initRotate(this.a, theta, phi, angle);
    }

    private void initRotate(Point3D a, double theta, double phi, double alpha) {
        double cosAlpha = Math.cos(alpha);
        double sinAlpha = Math.sin(alpha);
        double cosPhi = Math.cos(phi);
        double cosPhi2 = cosPhi * cosPhi;
        double sinPhi = Math.sin(phi);
        double sinPhi2 = sinPhi * sinPhi;
        double cosTheta = Math.cos(theta);
        double cosTheta2 = cosTheta * cosTheta;
        double sinTheta = Math.sin(theta);
        double sinTheta2 = sinTheta * sinTheta;
        double a1 = a.x;
        double a2 = a.y;
        double a3 = a.z;
        double c = 1.0 - cosAlpha;
        this.r11 = cosTheta2 * (cosAlpha * cosPhi2 + sinPhi2) + cosAlpha * sinTheta2;
        this.r12 = sinAlpha * cosPhi + c * sinPhi2 * cosTheta * sinTheta;
        this.r13 = sinPhi * (cosPhi * cosTheta * c - sinAlpha * sinTheta);
        this.r21 = sinPhi2 * cosTheta * sinTheta * c - sinAlpha * cosPhi;
        this.r22 = sinTheta2 * (cosAlpha * cosPhi2 + sinPhi2) + cosAlpha * cosTheta2;
        this.r23 = sinPhi * (cosPhi * sinTheta * c + sinAlpha * cosTheta);
        this.r31 = sinPhi * (cosPhi * cosTheta * c + sinAlpha * sinTheta);
        this.r32 = sinPhi * (cosPhi * sinTheta * c - sinAlpha * cosTheta);
        this.r33 = cosAlpha * sinPhi2 + cosPhi2;
        this.r41 = a1 - a1 * this.r11 - a2 * this.r21 - a3 * this.r31;
        this.r42 = a2 - a1 * this.r12 - a2 * this.r22 - a3 * this.r32;
        this.r43 = a3 - a1 * this.r13 - a2 * this.r23 - a3 * this.r33;
    }

    public Point3D applyRotation(Point3D p) {
        return this.applyRotation(p.x, p.y, p.z);
    }

    public Point3D applyRotation(double x, double y, double z) {
        return new Point3D(x * this.r11 + y * this.r21 + z * this.r31 + this.r41, x * this.r12 + y * this.r22 + z * this.r32 + this.r42, x * this.r13 + y * this.r23 + z * this.r33 + this.r43);
    }

    public double[] applyRotation(double x, double y, double z, double[] result) {
        if (result == null) {
            result = new double[]{x * this.r11 + y * this.r21 + z * this.r31 + this.r41, x * this.r12 + y * this.r22 + z * this.r32 + this.r42, x * this.r13 + y * this.r23 + z * this.r33 + this.r43};
        }
        return result;
    }
}

