/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.graphics3d.DoubleSidedFace;
import org.jfree.chart3d.graphics3d.Face;
import org.jfree.chart3d.graphics3d.LabelFace;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.ViewPoint3D;
import org.jfree.chart3d.graphics3d.internal.TaggedFace;
import org.jfree.chart3d.internal.Args;

public class Object3D {
    public static final String CLASS_KEY = "class";
    public static final String ITEM_KEY = "key";
    public static final String COLOR_PREFIX = "color/";
    private List<Point3D> vertices;
    private List<Face> faces;
    private Color color;
    private boolean outline;
    private Map<String, Object> properties;

    public Object3D(Color color) {
        this(color, false);
    }

    public Object3D(Color color, boolean outline) {
        Args.nullNotPermitted(color, "color");
        this.color = color;
        this.outline = outline;
        this.vertices = new ArrayList<Point3D>();
        this.faces = new ArrayList<Face>();
    }

    public Color getColor() {
        return this.color;
    }

    public boolean getOutline() {
        return this.outline;
    }

    public void setOutline(boolean outline) {
        this.outline = outline;
    }

    public Object getProperty(String key) {
        Args.nullNotPermitted(key, ITEM_KEY);
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        Args.nullNotPermitted(key, ITEM_KEY);
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(key, value);
    }

    public Color getColor(Face face) {
        Object obj;
        if (face.getTag() != null && (obj = this.getProperty(COLOR_PREFIX + face.getTag())) != null) {
            return (Color)obj;
        }
        return this.color;
    }

    public boolean getOutline(Face face) {
        return this.outline;
    }

    public int getVertexCount() {
        return this.vertices.size();
    }

    public void addVertex(double x, double y, double z) {
        this.addVertex(new Point3D(x, y, z));
    }

    public void addVertex(Point3D vertex) {
        Args.nullNotPermitted(vertex, "vertex");
        this.vertices.add(vertex);
    }

    public int getFaceCount() {
        return this.faces.size();
    }

    public void addFace(int[] vertices) {
        this.addFace(new Face(this, vertices));
    }

    public void addFace(int[] vertices, String tag) {
        this.addFace(new TaggedFace(this, vertices, tag));
    }

    public void addDoubleSidedFace(int[] vertices) {
        this.addFace(new DoubleSidedFace(this, vertices));
    }

    public void addFace(Face face) {
        Args.nullNotPermitted(face, "face");
        this.faces.add(face);
    }

    public List<Face> getFaces() {
        return this.faces;
    }

    public Point2D[] calculateProjectedPoints(ViewPoint3D viewPoint, double d) {
        Args.nullNotPermitted(viewPoint, "viewPoint");
        Point2D[] result = new Point2D[this.vertices.size()];
        int vertexCount = this.vertices.size();
        for (int i = 0; i < vertexCount; ++i) {
            Point3D p = this.vertices.get(i);
            result[i] = viewPoint.worldToScreen(p, d);
        }
        return result;
    }

    public Point3D[] calculateEyeCoordinates(ViewPoint3D viewPoint) {
        Args.nullNotPermitted(viewPoint, "viewPoint");
        Point3D[] result = new Point3D[this.vertices.size()];
        int i = 0;
        for (Point3D vertex : this.vertices) {
            result[i] = viewPoint.worldToEye(vertex);
            ++i;
        }
        return result;
    }

    public static Object3D createYSheet(double size, double x, double y, double z, Color color, boolean invert) {
        Args.nullNotPermitted(color, "color");
        Object3D sheet = new Object3D(color);
        double delta = size / 2.0;
        sheet.addVertex(new Point3D(x + delta, y, z - delta));
        sheet.addVertex(new Point3D(x + delta, y, z + delta));
        sheet.addVertex(new Point3D(x - delta, y, z + delta));
        sheet.addVertex(new Point3D(x - delta, y, z - delta));
        if (invert) {
            sheet.addFace(new Face(sheet, new int[]{3, 2, 1, 0}));
        } else {
            sheet.addFace(new Face(sheet, new int[]{0, 1, 2, 3}));
        }
        return sheet;
    }

    public static Object3D createZSheet(double size, double x, double y, double z, Color color) {
        Object3D sheet = new Object3D(color);
        double delta = size / 2.0;
        sheet.addVertex(new Point3D(x + delta, y - delta, z));
        sheet.addVertex(new Point3D(x + delta, y + delta, z));
        sheet.addVertex(new Point3D(x - delta, y + delta, z));
        sheet.addVertex(new Point3D(x - delta, y - delta, z));
        sheet.addFace(new Face(sheet, new int[]{0, 1, 2, 3}));
        return sheet;
    }

    public static Object3D createCube(double size, double x, double y, double z, Color color) {
        return Object3D.createBox(x, size, y, size, z, size, color);
    }

    public static Object3D createBox(double x, double xdim, double y, double ydim, double z, double zdim, Color color) {
        Args.nullNotPermitted(color, "color");
        Object3D box = new Object3D(color);
        double xdelta = xdim / 2.0;
        double ydelta = ydim / 2.0;
        double zdelta = zdim / 2.0;
        box.addVertex(new Point3D(x - xdelta, y - ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y - ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y - ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y - ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y + ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y + ydelta, z - zdelta));
        box.addVertex(new Point3D(x + xdelta, y + ydelta, z + zdelta));
        box.addVertex(new Point3D(x - xdelta, y + ydelta, z + zdelta));
        box.addFace(new Face(box, new int[]{4, 5, 1, 0}));
        box.addFace(new Face(box, new int[]{5, 6, 2, 1}));
        box.addFace(new Face(box, new int[]{6, 7, 3, 2}));
        box.addFace(new Face(box, new int[]{3, 7, 4, 0}));
        box.addFace(new Face(box, new int[]{7, 6, 5, 4}));
        box.addFace(new Face(box, new int[]{0, 1, 2, 3}));
        return box;
    }

    public static Object3D createTetrahedron(double size, double xOffset, double yOffset, double zOffset, Color color) {
        Args.nullNotPermitted(color, "color");
        Object3D tetra = new Object3D(color);
        tetra.addVertex(new Point3D(size + xOffset, -size + yOffset, -size + zOffset));
        tetra.addVertex(new Point3D(-size + xOffset, size + yOffset, -size + zOffset));
        tetra.addVertex(new Point3D(size + xOffset, size + yOffset, size + zOffset));
        tetra.addVertex(new Point3D(-size + xOffset, -size + yOffset, size + zOffset));
        tetra.addFace(new Face(tetra, new int[]{0, 1, 2}));
        tetra.addFace(new Face(tetra, new int[]{1, 3, 2}));
        tetra.addFace(new Face(tetra, new int[]{0, 3, 1}));
        tetra.addFace(new Face(tetra, new int[]{0, 2, 3}));
        return tetra;
    }

    public static Object3D createOctahedron(double size, double xOffset, double yOffset, double zOffset, Color color) {
        Args.nullNotPermitted(color, "color");
        Object3D octa = new Object3D(color);
        octa.addVertex(new Point3D(size + xOffset, 0.0 + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, size + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(-size + xOffset, 0.0 + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, -size + yOffset, 0.0 + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, 0.0 + yOffset, -size + zOffset));
        octa.addVertex(new Point3D(0.0 + xOffset, 0.0 + yOffset, size + zOffset));
        octa.addFace(new Face(octa, new int[]{0, 1, 5}));
        octa.addFace(new Face(octa, new int[]{1, 2, 5}));
        octa.addFace(new Face(octa, new int[]{2, 3, 5}));
        octa.addFace(new Face(octa, new int[]{3, 0, 5}));
        octa.addFace(new Face(octa, new int[]{1, 0, 4}));
        octa.addFace(new Face(octa, new int[]{2, 1, 4}));
        octa.addFace(new Face(octa, new int[]{3, 2, 4}));
        octa.addFace(new Face(octa, new int[]{0, 3, 4}));
        return octa;
    }

    public static Object3D createSphere(double radius, int n, double x, double y, double z, Color extColor, Color intColor) {
        Object3D sphere = new Object3D(extColor);
        sphere.setProperty("color/interior", intColor);
        double theta = Math.PI / (double)n;
        Point3D[] prevLayer = new Point3D[n * 2 + 1];
        for (int i = 0; i <= n * 2; ++i) {
            prevLayer[i] = new Point3D(x, y + radius, z);
            if (i == n * 2) continue;
            sphere.addVertex(prevLayer[i]);
        }
        for (int layer = 1; layer < n; ++layer) {
            Point3D[] currLayer = new Point3D[n * 2 + 1];
            for (int i = 0; i <= n * 2; ++i) {
                double xx = radius * Math.cos((double)i * theta) * Math.sin((double)layer * theta);
                double yy = radius * Math.cos((double)layer * theta);
                double zz = radius * Math.sin((double)i * theta) * Math.sin((double)layer * theta);
                currLayer[i] = new Point3D(x + xx, y + yy, z + zz);
                if (i != n * 2) {
                    sphere.addVertex(currLayer[i]);
                }
                if (i <= 0 || layer <= 1) continue;
                if (i != n * 2) {
                    Face f = new Face(sphere, new int[]{(layer - 1) * n * 2 + i - 1, (layer - 1) * n * 2 + i, layer * n * 2 + i, layer * n * 2 + i - 1});
                    sphere.addFace(f);
                    f = new TaggedFace(sphere, new int[]{layer * n * 2 + i - 1, layer * n * 2 + i, (layer - 1) * n * 2 + i, (layer - 1) * n * 2 + i - 1}, "interior");
                    sphere.addFace(f);
                    continue;
                }
                sphere.addFace(new Face(sphere, new int[]{(layer - 1) * n * 2 + i - 1, (layer - 1) * n * 2, layer * n * 2, layer * n * 2 + i - 1}));
                sphere.addFace(new TaggedFace(sphere, new int[]{layer * n * 2 + i - 1, layer * n * 2, (layer - 1) * n * 2, (layer - 1) * n * 2 + i - 1}, "interior"));
            }
        }
        return sphere;
    }

    public static Object3D createPieSegment(double radius, double explodeRadius, double base, double height, double angle1, double angle2, double inc, Color color) {
        Args.nullNotPermitted(color, "color");
        Object3D segment = new Object3D(color, true);
        double angleCentre = (angle1 + angle2) / 2.0;
        Point3D centre = new Point3D(explodeRadius * Math.cos(angleCentre), base, explodeRadius * Math.sin(angleCentre));
        float cx = (float)centre.x;
        float cz = (float)centre.z;
        segment.addVertex(new Point3D((double)cx + 0.0, base, (double)cz + 0.0));
        segment.addVertex(new Point3D((double)cx + 0.0, base + height, (double)cz + 0.0));
        Point3D v0 = new Point3D((double)cx + radius * Math.cos(angle1), base, (double)cz + radius * Math.sin(angle1));
        Point3D v1 = new Point3D((double)cx + radius * Math.cos(angle1), base + height, (double)cz + radius * Math.sin(angle1));
        segment.addVertex(v0);
        segment.addVertex(v1);
        segment.addFace(new Face(segment, new int[]{1, 3, 2, 0}));
        int vc = 4;
        for (double theta = angle1 + inc; theta < angle2; theta += inc) {
            Point3D v2 = new Point3D((double)cx + radius * Math.cos(theta), base, (double)cz + radius * Math.sin(theta));
            Point3D v3 = new Point3D((double)cx + radius * Math.cos(theta), base + height, (double)cz + radius * Math.sin(theta));
            segment.addVertex(v2);
            segment.addVertex(v3);
            segment.addFace(new Face(segment, new int[]{(vc += 2) - 2, vc - 4, vc - 3, vc - 1}));
            segment.addFace(new Face(segment, new int[]{0, vc - 4, vc - 2, 0}));
            segment.addFace(new Face(segment, new int[]{1, vc - 1, vc - 3, 1}));
        }
        v0 = new Point3D((double)cx + radius * Math.cos(angle2), base, (double)cz + radius * Math.sin(angle2));
        v1 = new Point3D((double)cx + radius * Math.cos(angle2), base + height, (double)cz + radius * Math.sin(angle2));
        segment.addVertex(v0);
        segment.addVertex(v1);
        segment.addFace(new Face(segment, new int[]{(vc += 2) - 2, vc - 4, vc - 3, vc - 1}));
        segment.addFace(new Face(segment, new int[]{0, vc - 4, vc - 2, 0}));
        segment.addFace(new Face(segment, new int[]{1, vc - 1, vc - 3, 1}));
        segment.addFace(new Face(segment, new int[]{1, 0, vc - 2, vc - 1}));
        return segment;
    }

    public static List<Object3D> createPieLabelMarkers(double radius, double explodeRadius, double base, double height, double angle1, double angle2) {
        ArrayList<Object3D> result = new ArrayList<Object3D>();
        double angle = (angle1 + angle2) / 2.0;
        Point3D centre = new Point3D(explodeRadius * Math.cos(angle), base, explodeRadius * Math.sin(angle));
        float cx = (float)centre.x;
        float cz = (float)centre.z;
        double r = radius * 0.9;
        Point3D v0 = new Point3D((double)cx + r * Math.cos(angle), base, (double)cz + r * Math.sin(angle));
        Point3D v1 = new Point3D((double)cx + r * Math.cos(angle), base + height, (double)cz + r * Math.sin(angle));
        result.add(Object3D.createYSheet(2.0, v0.x, v0.y, v0.z, Color.RED, false));
        result.add(Object3D.createYSheet(2.0, v1.x, v1.y, v1.z, Color.BLUE, true));
        return result;
    }

    public static Object3D createBar(double xWidth, double zWidth, double x, double y, double z, double zero, Color barColor, Color baseColor, Color topColor, boolean inverted) {
        Args.nullNotPermitted(barColor, "barColor");
        Color c0 = baseColor;
        Color c1 = topColor;
        if (inverted) {
            Color cc = c1;
            c1 = c0;
            c0 = cc;
        }
        Object3D bar = new Object3D(barColor);
        if (c0 != null) {
            bar.setProperty("color/c0", c0);
        }
        if (c1 != null) {
            bar.setProperty("color/c1", c1);
        }
        double xdelta = xWidth / 2.0;
        double zdelta = zWidth / 2.0;
        bar.addVertex(new Point3D(x - xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, zero, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z - zdelta));
        bar.addVertex(new Point3D(x + xdelta, y, z + zdelta));
        bar.addVertex(new Point3D(x - xdelta, y, z + zdelta));
        bar.addFace(new Face(bar, new int[]{0, 1, 5, 4}));
        bar.addFace(new Face(bar, new int[]{4, 5, 1, 0}));
        bar.addFace(new Face(bar, new int[]{1, 2, 6, 5}));
        bar.addFace(new Face(bar, new int[]{5, 6, 2, 1}));
        bar.addFace(new Face(bar, new int[]{2, 3, 7, 6}));
        bar.addFace(new Face(bar, new int[]{6, 7, 3, 2}));
        bar.addFace(new Face(bar, new int[]{0, 4, 7, 3}));
        bar.addFace(new Face(bar, new int[]{3, 7, 4, 0}));
        bar.addFace(new Face(bar, new int[]{4, 5, 6, 7}));
        bar.addFace(new Face(bar, new int[]{3, 2, 1, 0}));
        if (c1 != null) {
            bar.addFace(new TaggedFace(bar, new int[]{7, 6, 5, 4}, "c1"));
        } else {
            bar.addFace(new Face(bar, new int[]{7, 6, 5, 4}));
        }
        if (c0 != null) {
            bar.addFace(new TaggedFace(bar, new int[]{0, 1, 2, 3}, "c0"));
        } else {
            bar.addFace(new Face(bar, new int[]{0, 1, 2, 3}));
        }
        return bar;
    }

    public static Object3D createLabelObject(String label, Font font, Color fgColor, Color bgColor, double x, double y, double z, boolean reversed, boolean doubleSided) {
        Object3D labelObj = new Object3D(bgColor);
        labelObj.setProperty(CLASS_KEY, "ItemLabel");
        labelObj.addVertex(x - 0.1, y, z);
        labelObj.addVertex(x + 0.1, y, z);
        labelObj.addVertex(x + 0.1, y + 0.1, z);
        labelObj.addVertex(x - 0.1, y + 0.1, z);
        if (!reversed || doubleSided) {
            labelObj.addFace(new LabelFace(labelObj, new int[]{0, 1, 2, 3}, label, font, fgColor, bgColor));
        }
        if (reversed || doubleSided) {
            labelObj.addFace(new LabelFace(labelObj, new int[]{3, 2, 1, 0}, label, font, fgColor, bgColor));
        }
        return labelObj;
    }
}

