/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics3d;

import java.awt.Color;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import org.jfree.chart3d.graphics3d.Object3D;
import org.jfree.chart3d.graphics3d.Point3D;
import org.jfree.chart3d.graphics3d.internal.Utils2D;
import org.jfree.chart3d.internal.Args;

public class Face {
    private Object3D owner;
    private int offset;
    private int[] vertices;

    public Face(Object3D owner, int[] vertices) {
        if (vertices.length < 2) {
            throw new IllegalArgumentException("Faces must have at least two vertices.");
        }
        Args.nullNotPermitted(owner, "owner");
        this.owner = owner;
        this.vertices = vertices;
        this.offset = 0;
    }

    public Object3D getOwner() {
        return this.owner;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getVertexCount() {
        return this.vertices.length;
    }

    public int getVertexIndex(int i) {
        return this.vertices[i] + this.offset;
    }

    public Color getColor() {
        return this.owner.getColor(this);
    }

    public boolean getOutline() {
        return this.owner.getOutline(this);
    }

    public String getTag() {
        return null;
    }

    public double[] calculateNormal(Point3D[] points) {
        int iA = this.vertices[0] + this.offset;
        int iB = this.vertices[1] + this.offset;
        int iC = this.vertices[2] + this.offset;
        double aX = points[iA].x;
        double aY = points[iA].y;
        double aZ = points[iA].z;
        double bX = points[iB].x;
        double bY = points[iB].y;
        double bZ = points[iB].z;
        double cX = points[iC].x;
        double cY = points[iC].y;
        double cZ = points[iC].z;
        double u1 = bX - aX;
        double u2 = bY - aY;
        double u3 = bZ - aZ;
        double v1 = cX - aX;
        double v2 = cY - aY;
        double v3 = cZ - aZ;
        double a = u2 * v3 - u3 * v2;
        double b = u3 * v1 - u1 * v3;
        double c = u1 * v2 - u2 * v1;
        double len = Math.sqrt(a * a + b * b + c * c);
        return new double[]{a /= len, b /= len, c /= len};
    }

    public float calculateAverageZValue(Point3D[] points) {
        float total = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            total += (float)points[this.vertices[i] + this.offset].z;
        }
        return total / (float)this.vertices.length;
    }

    public boolean isFrontFacing(Point2D[] projPts) {
        return Utils2D.area2(projPts[this.getVertexIndex(0)], projPts[this.getVertexIndex(1)], projPts[this.getVertexIndex(2)]) > 0.0;
    }

    public Path2D createPath(Point2D[] pts) {
        Path2D.Float path = new Path2D.Float();
        for (int v = 0; v < this.getVertexCount(); ++v) {
            Point2D pt = pts[this.getVertexIndex(v)];
            if (v == 0) {
                ((Path2D)path).moveTo(pt.getX(), pt.getY());
                continue;
            }
            ((Path2D)path).lineTo(pt.getX(), pt.getY());
        }
        path.closePath();
        return path;
    }

    public String toString() {
        Object result = "[";
        for (int i = 0; i < this.vertices.length; ++i) {
            result = (String)result + this.vertices[i];
            if (i >= this.vertices.length - 1) continue;
            result = (String)result + ", ";
        }
        return (String)result + "]";
    }
}

