/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.graphics2d;

public enum TextAnchor {
    TOP_LEFT("TextAnchor.TOP_LEFT"),
    TOP_CENTER("TextAnchor.TOP_CENTER"),
    TOP_RIGHT("TextAnchor.TOP_RIGHT"),
    HALF_ASCENT_LEFT("TextAnchor.HALF_ASCENT_LEFT"),
    HALF_ASCENT_CENTER("TextAnchor.HALF_ASCENT_CENTER"),
    HALF_ASCENT_RIGHT("TextAnchor.HALF_ASCENT_RIGHT"),
    CENTER_LEFT("TextAnchor.CENTER_LEFT"),
    CENTER("TextAnchor.CENTER"),
    CENTER_RIGHT("TextAnchor.CENTER_RIGHT"),
    BASELINE_LEFT("TextAnchor.BASELINE_LEFT"),
    BASELINE_CENTER("TextAnchor.BASELINE_CENTER"),
    BASELINE_RIGHT("TextAnchor.BASELINE_RIGHT"),
    BOTTOM_LEFT("TextAnchor.BOTTOM_LEFT"),
    BOTTOM_CENTER("TextAnchor.BOTTOM_CENTER"),
    BOTTOM_RIGHT("TextAnchor.BOTTOM_RIGHT");

    private final String name;

    private TextAnchor(String name) {
        this.name = name;
    }

    public boolean isLeft() {
        return this == TOP_LEFT || this == CENTER_LEFT || this == HALF_ASCENT_LEFT || this == BASELINE_LEFT || this == BOTTOM_LEFT;
    }

    public boolean isHorizontalCenter() {
        return this == TOP_CENTER || this == CENTER || this == HALF_ASCENT_CENTER || this == BASELINE_CENTER || this == BOTTOM_CENTER;
    }

    public boolean isRight() {
        return this == TOP_RIGHT || this == CENTER_RIGHT || this == HALF_ASCENT_RIGHT || this == BASELINE_RIGHT || this == BOTTOM_RIGHT;
    }

    public boolean isTop() {
        return this == TOP_LEFT || this == TOP_CENTER || this == TOP_RIGHT;
    }

    public boolean isHalfAscent() {
        return this == HALF_ASCENT_LEFT || this == HALF_ASCENT_CENTER || this == HALF_ASCENT_RIGHT;
    }

    public boolean isHalfHeight() {
        return this == CENTER_LEFT || this == CENTER || this == CENTER_RIGHT;
    }

    public boolean isBaseline() {
        return this == BASELINE_LEFT || this == BASELINE_CENTER || this == BASELINE_RIGHT;
    }

    public boolean isBottom() {
        return this == BOTTOM_LEFT || this == BOTTOM_CENTER || this == BOTTOM_RIGHT;
    }

    public String toString() {
        return this.name;
    }
}

