/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart3d.data.DefaultKeyedValues2D;
import org.jfree.chart3d.data.KeyedValues3D;
import org.jfree.chart3d.internal.Args;

public final class DefaultKeyedValues3D<S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>, V>
implements KeyedValues3D<S, R, C, V>,
Serializable {
    private final List<S> seriesKeys = new ArrayList<S>();
    private final List<R> rowKeys = new ArrayList<R>();
    private List<C> columnKeys = new ArrayList<C>();
    private List<DefaultKeyedValues2D<R, C, V>> data = new ArrayList<DefaultKeyedValues2D<R, C, V>>();

    @Override
    public S getSeriesKey(int seriesIndex) {
        return (S)((Comparable)this.seriesKeys.get(seriesIndex));
    }

    @Override
    public R getRowKey(int rowIndex) {
        return (R)((Comparable)this.rowKeys.get(rowIndex));
    }

    @Override
    public C getColumnKey(int columnIndex) {
        return (C)((Comparable)this.columnKeys.get(columnIndex));
    }

    @Override
    public int getSeriesIndex(S seriesKey) {
        Args.nullNotPermitted(seriesKey, "seriesKey");
        return this.seriesKeys.indexOf(seriesKey);
    }

    @Override
    public int getRowIndex(R rowKey) {
        Args.nullNotPermitted(rowKey, "rowKey");
        return this.rowKeys.indexOf(rowKey);
    }

    @Override
    public int getColumnIndex(C columnKey) {
        Args.nullNotPermitted(columnKey, "columnKey");
        return this.columnKeys.indexOf(columnKey);
    }

    @Override
    public List<S> getSeriesKeys() {
        return new ArrayList<S>(this.seriesKeys);
    }

    @Override
    public List<R> getRowKeys() {
        return new ArrayList<R>(this.rowKeys);
    }

    @Override
    public List<C> getColumnKeys() {
        return new ArrayList<C>(this.columnKeys);
    }

    @Override
    public int getSeriesCount() {
        return this.seriesKeys.size();
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public V getValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.get(seriesIndex).getValue(rowIndex, columnIndex);
    }

    @Override
    public V getValue(S seriesKey, R rowKey, C columnKey) {
        int seriesIndex = this.getSeriesIndex(seriesKey);
        if (seriesIndex < 0) {
            throw new IllegalArgumentException("Series '" + seriesKey.toString() + "' is not found.");
        }
        int rowIndex = this.getRowIndex(rowKey);
        if (rowIndex < 0) {
            throw new IllegalArgumentException("Row key '" + rowKey.toString() + "' is not found.");
        }
        int columnIndex = this.getColumnIndex(columnKey);
        if (columnIndex < 0) {
            throw new IllegalArgumentException("Column key '" + columnKey.toString() + "' is not found.");
        }
        return this.getValue((S)seriesIndex, (R)rowIndex, (C)columnIndex);
    }

    @Override
    public double getDoubleValue(int seriesIndex, int rowIndex, int columnIndex) {
        V n = this.getValue((S)seriesIndex, (R)rowIndex, (C)columnIndex);
        if (n != null && n instanceof Number) {
            return ((Number)n).doubleValue();
        }
        return Double.NaN;
    }

    public void setValue(V n, S seriesKey, R rowKey, C columnKey) {
        DefaultKeyedValues2D<R, C, Object> d;
        Args.nullNotPermitted(seriesKey, "seriesKey");
        Args.nullNotPermitted(rowKey, "rowKey");
        Args.nullNotPermitted(columnKey, "columnKey");
        if (this.data.isEmpty()) {
            this.seriesKeys.add(seriesKey);
            this.rowKeys.add(rowKey);
            this.columnKeys.add(columnKey);
            DefaultKeyedValues2D<R, C, V> d2 = new DefaultKeyedValues2D<R, C, V>();
            d2.setValue(n, rowKey, columnKey);
            this.data.add(d2);
        }
        int seriesIndex = this.getSeriesIndex(seriesKey);
        int rowIndex = this.getRowIndex(rowKey);
        int columnIndex = this.getColumnIndex(columnKey);
        if (rowIndex < 0) {
            this.rowKeys.add(rowKey);
        }
        if (columnIndex < 0) {
            this.columnKeys.add(columnKey);
        }
        if (rowIndex < 0 || columnIndex < 0) {
            for (DefaultKeyedValues2D<R, C, V> d3 : this.data) {
                d3.setValue(null, rowKey, columnKey);
            }
        }
        if (seriesIndex >= 0) {
            d = this.data.get(seriesIndex);
            d.setValue(n, rowKey, columnKey);
        } else {
            this.seriesKeys.add(seriesKey);
            d = new DefaultKeyedValues2D(this.rowKeys, this.columnKeys);
            d.setValue(n, rowKey, columnKey);
            this.data.add(d);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValues3D)) {
            return false;
        }
        DefaultKeyedValues3D that = (DefaultKeyedValues3D)obj;
        if (!this.seriesKeys.equals(that.seriesKeys)) {
            return false;
        }
        if (!this.rowKeys.equals(that.rowKeys)) {
            return false;
        }
        if (!this.columnKeys.equals(that.columnKeys)) {
            return false;
        }
        return this.data.equals(that.data);
    }
}

