/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.data;

import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.data.Dataset3D;
import org.jfree.chart3d.data.Dataset3DChangeEvent;
import org.jfree.chart3d.data.Dataset3DChangeListener;

public class AbstractDataset3D
implements Dataset3D {
    private final transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractDataset3D() {
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(Dataset3DChangeListener listener) {
        this.listenerList.add(Dataset3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Dataset3DChangeListener listener) {
        this.listenerList.remove(Dataset3DChangeListener.class, listener);
    }

    @Override
    public boolean hasListener(EventListener listener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(listener);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new Dataset3DChangeEvent(this, this));
    }

    protected void notifyListeners(Dataset3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Dataset3DChangeListener.class) continue;
            ((Dataset3DChangeListener)listeners[i + 1]).datasetChanged(event);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Dataset3DChangeEvent(this, this));
    }
}

