/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.axis;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart3d.Chart3DHints;
import org.jfree.chart3d.axis.AbstractValueAxis3D;
import org.jfree.chart3d.axis.LabelOrientation;
import org.jfree.chart3d.axis.NumberTickSelector;
import org.jfree.chart3d.axis.TickData;
import org.jfree.chart3d.axis.TickSelector;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.graphics2d.TextAnchor;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.internal.Utils2D;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.TextUtils;

public class NumberAxis3D
extends AbstractValueAxis3D
implements ValueAxis3D,
Serializable {
    private static final Format DEFAULT_TICK_LABEL_FORMATTER = new DecimalFormat("0.00");
    private boolean autoRangeIncludesZero = false;
    private boolean autoRangeStickyZero = true;
    private TickSelector tickSelector = new NumberTickSelector();
    private double tickSize;
    private Format tickLabelFormatter;

    public NumberAxis3D(String label) {
        this(label, new Range(0.0, 1.0));
    }

    public NumberAxis3D(String label, Range range) {
        super(label, range);
        this.tickSize = range.getLength() / 10.0;
        this.tickLabelFormatter = DEFAULT_TICK_LABEL_FORMATTER;
    }

    public boolean getAutoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludeZero(boolean include) {
        this.autoRangeIncludesZero = include;
        this.fireChangeEvent(true);
    }

    public boolean getAutoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean sticky) {
        this.autoRangeStickyZero = sticky;
        this.fireChangeEvent(true);
    }

    public TickSelector getTickSelector() {
        return this.tickSelector;
    }

    public void setTickSelector(TickSelector selector) {
        this.tickSelector = selector;
        this.fireChangeEvent(false);
    }

    public double getTickSize() {
        return this.tickSize;
    }

    public void setTickSize(double tickSize) {
        this.tickSize = tickSize;
        this.fireChangeEvent(false);
    }

    public Format getTickLabelFormatter() {
        return this.tickLabelFormatter;
    }

    public void setTickLabelFormatter(Format formatter) {
        Args.nullNotPermitted(formatter, "formatter");
        this.tickLabelFormatter = formatter;
        this.fireChangeEvent(false);
    }

    @Override
    protected Range adjustedDataRange(Range range) {
        Args.nullNotPermitted(range, "range");
        double lm = range.getLength() * this.getLowerMargin();
        double um = range.getLength() * this.getUpperMargin();
        double lowerBound = range.getMin() - lm;
        double upperBound = range.getMax() + um;
        if (this.autoRangeIncludesZero) {
            lowerBound = Math.min(lowerBound, 0.0);
            upperBound = Math.max(upperBound, 0.0);
        }
        if (this.autoRangeStickyZero) {
            if (0.0 <= range.getMin() && 0.0 > lowerBound) {
                lowerBound = 0.0;
            }
            if (0.0 >= range.getMax() && 0.0 < upperBound) {
                upperBound = 0.0;
            }
        }
        if (upperBound - lowerBound < this.getMinAutoRangeLength()) {
            double adj = (this.getMinAutoRangeLength() - (upperBound - lowerBound)) / 2.0;
            lowerBound -= adj;
            upperBound += adj;
        }
        return new Range(lowerBound, upperBound);
    }

    @Override
    public void draw(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        if (!this.isVisible()) {
            return;
        }
        if (pt0.equals(pt1)) {
            return;
        }
        g2.setStroke(this.getLineStroke());
        g2.setPaint(this.getLineColor());
        Line2D.Float axisLine = new Line2D.Float(pt0, pt1);
        g2.draw(axisLine);
        g2.setFont(this.getTickLabelFont());
        double maxTickLabelDim = 0.0;
        if (this.getTickLabelOrientation().equals((Object)LabelOrientation.PARALLEL)) {
            LineMetrics lm = g2.getFontMetrics().getLineMetrics("123", g2);
            maxTickLabelDim = lm.getHeight();
        }
        double tickMarkLength = this.getTickMarkLength();
        double tickLabelOffset = this.getTickLabelOffset();
        g2.setPaint(this.getTickMarkPaint());
        g2.setStroke(this.getTickMarkStroke());
        for (TickData t : tickData) {
            if (tickMarkLength > 0.0) {
                Line2D tickLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), tickMarkLength, opposingPt);
                g2.draw(tickLine);
            }
            String tickLabel = this.tickLabelFormatter.format(t.getDataValue());
            if (!this.getTickLabelOrientation().equals((Object)LabelOrientation.PERPENDICULAR)) continue;
            maxTickLabelDim = Math.max(maxTickLabelDim, (double)g2.getFontMetrics().stringWidth(tickLabel));
        }
        if (this.getTickLabelsVisible()) {
            g2.setPaint(this.getTickLabelColor());
            if (this.getTickLabelOrientation().equals((Object)LabelOrientation.PERPENDICULAR)) {
                this.drawPerpendicularTickLabels(g2, axisLine, opposingPt, tickData, info, hinting);
            } else {
                this.drawParallelTickLabels(g2, axisLine, opposingPt, tickData, info, hinting);
            }
        } else {
            maxTickLabelDim = 0.0;
        }
        if (this.getLabel() != null) {
            Shape shape = this.drawAxisLabel(this.getLabel(), g2, axisLine, opposingPt, maxTickLabelDim + tickMarkLength + tickLabelOffset + this.getLabelOffset(), info, hinting);
        }
    }

    private void drawParallelTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        g2.setFont(this.getTickLabelFont());
        double halfAscent = (double)g2.getFontMetrics().getAscent() / 2.0;
        for (TickData t : tickData) {
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.getTickMarkLength() + this.getTickLabelOffset() + halfAscent, opposingPt);
            double axisTheta = Utils2D.calculateTheta(axisLine);
            TextAnchor textAnchor = TextAnchor.CENTER;
            if (axisTheta >= 1.5707963267948966) {
                axisTheta -= Math.PI;
            } else if (axisTheta <= -1.5707963267948966) {
                axisTheta += Math.PI;
            }
            String tickLabel = this.tickLabelFormatter.format(t.getDataValue());
            if (hinting) {
                HashMap<String, CallSite> m = new HashMap<String, CallSite>();
                m.put("ref", (CallSite)((Object)("{\"type\": \"valueTickLabel\", \"axis\": \"" + this.axisStr() + "\", \"value\": \"" + t.getDataValue() + "\"}")));
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            Shape bounds = TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, axisTheta, textAnchor);
            if (hinting) {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
            }
            if (info == null) continue;
            RenderedElement tickLabelElement = new RenderedElement((Object)InteractiveElementType.VALUE_AXIS_TICK_LABEL, bounds);
            tickLabelElement.setProperty("axis", this.axisStr());
            tickLabelElement.setProperty("value", t.getDataValue());
            info.addOffsetElement(tickLabelElement);
        }
    }

    private void drawPerpendicularTickLabels(Graphics2D g2, Line2D axisLine, Point2D opposingPt, List<TickData> tickData, RenderingInfo info, boolean hinting) {
        for (TickData t : tickData) {
            double theta = Utils2D.calculateTheta(axisLine);
            double thetaAdj = theta + 1.5707963267948966;
            if (thetaAdj < -1.5707963267948966) {
                thetaAdj += Math.PI;
            }
            if (thetaAdj > 1.5707963267948966) {
                thetaAdj -= Math.PI;
            }
            Line2D perpLine = Utils2D.createPerpendicularLine(axisLine, t.getAnchorPt(), this.getTickMarkLength() + this.getTickLabelOffset(), opposingPt);
            double perpTheta = Utils2D.calculateTheta(perpLine);
            TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
            if (Math.abs(perpTheta) > 1.5707963267948966) {
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            String tickLabel = this.tickLabelFormatter.format(t.getDataValue());
            if (hinting) {
                HashMap<String, CallSite> m = new HashMap<String, CallSite>();
                m.put("ref", (CallSite)((Object)("{\"type\": \"valueTickLabel\", \"axis\": \"" + this.axisStr() + "\", \"value\": \"" + t.getDataValue() + "\"}")));
                g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
            }
            Shape bounds = TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, thetaAdj, textAnchor);
            if (hinting) {
                g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
            }
            if (info == null) continue;
            RenderedElement tickLabelElement = new RenderedElement((Object)InteractiveElementType.VALUE_AXIS_TICK_LABEL, bounds);
            tickLabelElement.setProperty("axis", this.axisStr());
            tickLabelElement.setProperty("value", t.getDataValue());
            info.addOffsetElement(tickLabelElement);
        }
    }

    @Override
    public double translateToWorld(double value, double length) {
        double p = this.getRange().percent(value, this.isInverted());
        return length * p;
    }

    @Override
    public double selectTick(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt) {
        if (this.tickSelector == null) {
            return this.tickSize;
        }
        g2.setFont(this.getTickLabelFont());
        FontMetrics fm = g2.getFontMetrics(this.getTickLabelFont());
        double length = pt0.distance(pt1);
        LabelOrientation orientation = this.getTickLabelOrientation();
        if (orientation.equals((Object)LabelOrientation.PERPENDICULAR)) {
            double height = fm.getHeight();
            int maxTicks = (int)(length / (height * this.getTickLabelFactor()));
            if (maxTicks > 2 && this.tickSelector != null) {
                double rangeLength = this.getRange().getLength();
                this.tickSelector.select(rangeLength / 2.0);
                int tickCount = (int)(rangeLength / this.tickSelector.getCurrentTickSize());
                while (tickCount < maxTicks) {
                    this.tickSelector.previous();
                    tickCount = (int)(rangeLength / this.tickSelector.getCurrentTickSize());
                }
                this.tickSelector.next();
                this.tickSize = this.tickSelector.getCurrentTickSize();
                if (DEFAULT_TICK_LABEL_FORMATTER.equals(this.tickLabelFormatter)) {
                    this.tickLabelFormatter = this.tickSelector.getCurrentTickLabelFormat();
                }
            } else {
                this.tickSize = Double.NaN;
            }
        } else if (orientation.equals((Object)LabelOrientation.PARALLEL)) {
            this.tickSelector.select(this.getRange().getLength());
            boolean done = false;
            while (!done) {
                if (this.tickSelector.previous()) {
                    double w1;
                    Format f = this.tickSelector.getCurrentTickLabelFormat();
                    String s0 = f.format(this.range.getMin());
                    String s1 = f.format(this.range.getMax());
                    double w0 = fm.stringWidth(s0);
                    double w = Math.max(w0, w1 = (double)fm.stringWidth(s1));
                    int n = (int)(length / (w * this.getTickLabelFactor()));
                    if (!((double)n < this.getRange().getLength() / this.tickSelector.getCurrentTickSize())) continue;
                    this.tickSelector.next();
                    done = true;
                    continue;
                }
                done = true;
            }
            this.tickSize = this.tickSelector.getCurrentTickSize();
            if (DEFAULT_TICK_LABEL_FORMATTER.equals(this.tickLabelFormatter)) {
                this.tickLabelFormatter = this.tickSelector.getCurrentTickLabelFormat();
            }
        }
        return this.tickSize;
    }

    @Override
    public List<TickData> generateTickData(double tickUnit) {
        ArrayList<TickData> result = new ArrayList<TickData>();
        if (Double.isNaN(tickUnit)) {
            result.add(new TickData(0.0, this.getRange().getMin()));
            result.add(new TickData(1.0, this.getRange().getMax()));
        } else {
            for (double x = tickUnit * Math.ceil(this.range.getMin() / tickUnit); x <= this.range.getMax(); x += tickUnit) {
                result.add(new TickData(this.range.percent(x, this.isInverted()), x));
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberAxis3D)) {
            return false;
        }
        NumberAxis3D that = (NumberAxis3D)obj;
        if (this.autoRangeIncludesZero != that.autoRangeIncludesZero) {
            return false;
        }
        if (this.autoRangeStickyZero != that.autoRangeStickyZero) {
            return false;
        }
        if (this.tickSize != that.tickSize) {
            return false;
        }
        if (!ObjectUtils.equals(this.tickSelector, that.tickSelector)) {
            return false;
        }
        if (!this.tickLabelFormatter.equals(that.tickLabelFormatter)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.tickSize) ^ Double.doubleToLongBits(this.tickSize) >>> 32);
        hash = 59 * hash + ObjectUtils.hashCode(this.tickLabelFormatter);
        return hash;
    }
}

