/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.axis.AbstractAxis3D;
import org.jfree.chart3d.axis.LabelOrientation;
import org.jfree.chart3d.axis.ValueAxis3D;
import org.jfree.chart3d.axis.ValueAxis3DType;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.data.category.CategoryDataset3D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.marker.MarkerData;
import org.jfree.chart3d.marker.NumberMarker;
import org.jfree.chart3d.marker.RangeMarker;
import org.jfree.chart3d.marker.ValueMarker;
import org.jfree.chart3d.plot.CategoryPlot3D;
import org.jfree.chart3d.plot.XYZPlot;

public abstract class AbstractValueAxis3D
extends AbstractAxis3D
implements ValueAxis3D,
Serializable {
    private ValueAxis3DType configuredType;
    protected Range range;
    private boolean inverted;
    private boolean autoAdjustRange;
    private double lowerMargin;
    private double upperMargin;
    private Range defaultAutoRange;
    private double minAutoRangeLength;
    private double tickLabelOffset;
    private double tickMarkLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;
    private LabelOrientation tickLabelOrientation;
    private double tickLabelFactor;
    private final Map<String, ValueMarker> valueMarkers;

    public AbstractValueAxis3D(String label, Range range) {
        super(label);
        Args.nullNotPermitted(range, "range");
        this.configuredType = null;
        this.range = range;
        this.autoAdjustRange = true;
        this.lowerMargin = 0.05;
        this.upperMargin = 0.05;
        this.defaultAutoRange = new Range(0.0, 1.0);
        this.minAutoRangeLength = 0.001;
        this.tickLabelOffset = 5.0;
        this.tickLabelOrientation = LabelOrientation.PARALLEL;
        this.tickLabelFactor = 1.4;
        this.tickMarkLength = 3.0;
        this.tickMarkStroke = new BasicStroke(0.5f);
        this.tickMarkPaint = Color.GRAY;
        this.valueMarkers = new LinkedHashMap<String, ValueMarker>();
    }

    @Override
    public ValueAxis3DType getConfiguredType() {
        return this.configuredType;
    }

    @Override
    protected String axisStr() {
        if (this.configuredType == null) {
            return "";
        }
        if (this.configuredType.equals((Object)ValueAxis3DType.VALUE)) {
            return "value";
        }
        if (this.configuredType.equals((Object)ValueAxis3DType.X)) {
            return "x";
        }
        if (this.configuredType.equals((Object)ValueAxis3DType.Y)) {
            return "y";
        }
        if (this.configuredType.equals((Object)ValueAxis3DType.Z)) {
            return "z";
        }
        return "";
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setRange(Range range) {
        Args.nullNotPermitted(range, "range");
        if (range.getLength() <= 0.0) {
            throw new IllegalArgumentException("Requires a range with length > 0");
        }
        this.range = range;
        this.autoAdjustRange = false;
        this.fireChangeEvent(true);
    }

    protected void updateRange(Range range) {
        this.range = range;
    }

    @Override
    public void setRange(double min, double max) {
        this.setRange(new Range(min, max));
    }

    public boolean isAutoAdjustRange() {
        return this.autoAdjustRange;
    }

    public void setAutoAdjustRange(boolean autoAdjust) {
        this.autoAdjustRange = autoAdjust;
        this.fireChangeEvent(true);
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.fireChangeEvent(true);
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.fireChangeEvent(true);
    }

    public Range getDefaultAutoRange() {
        return this.defaultAutoRange;
    }

    public void setDefaultAutoRange(Range range) {
        Args.nullNotPermitted(range, "range");
        this.defaultAutoRange = range;
        this.fireChangeEvent(true);
    }

    public double getMinAutoRangeLength() {
        return this.minAutoRangeLength;
    }

    public void setMinAutoRangeLength(double length) {
        Args.positiveRequired(length, "length");
        this.minAutoRangeLength = length;
        this.fireChangeEvent(this.range.getLength() < length);
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void setInverted(boolean inverted) {
        this.inverted = inverted;
        this.fireChangeEvent(true);
    }

    public LabelOrientation getTickLabelOrientation() {
        return this.tickLabelOrientation;
    }

    public void setTickLabelOrientation(LabelOrientation orientation) {
        Args.nullNotPermitted((Object)orientation, "orientation");
        this.tickLabelOrientation = orientation;
        this.fireChangeEvent(false);
    }

    public double getTickLabelFactor() {
        return this.tickLabelFactor;
    }

    public void setTickLabelFactor(double factor) {
        this.tickLabelFactor = factor;
        this.fireChangeEvent(false);
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double offset) {
        this.tickLabelOffset = offset;
    }

    public double getTickMarkLength() {
        return this.tickMarkLength;
    }

    public void setTickMarkLength(double length) {
        this.tickMarkLength = length;
        this.fireChangeEvent(false);
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.tickMarkStroke = stroke;
        this.fireChangeEvent(false);
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        Args.nullNotPermitted(paint, "paint");
        this.tickMarkPaint = paint;
        this.fireChangeEvent(false);
    }

    @Override
    public void configureAsValueAxis(CategoryPlot3D plot) {
        this.configuredType = ValueAxis3DType.VALUE;
        if (this.autoAdjustRange) {
            CategoryDataset3D dataset = plot.getDataset();
            Range valueRange = plot.getRenderer().findValueRange(dataset);
            if (valueRange != null) {
                this.updateRange(this.adjustedDataRange(valueRange));
            } else {
                this.updateRange(this.defaultAutoRange);
            }
        }
    }

    @Override
    public void configureAsXAxis(XYZPlot plot) {
        this.configuredType = ValueAxis3DType.X;
        if (this.autoAdjustRange) {
            Range xRange = plot.getRenderer().findXRange(plot.getDataset());
            if (xRange != null) {
                this.updateRange(this.adjustedDataRange(xRange));
            } else {
                this.updateRange(this.defaultAutoRange);
            }
        }
    }

    @Override
    public void configureAsYAxis(XYZPlot plot) {
        this.configuredType = ValueAxis3DType.Y;
        if (this.autoAdjustRange) {
            Range yRange = plot.getRenderer().findYRange(plot.getDataset());
            if (yRange != null) {
                this.updateRange(this.adjustedDataRange(yRange));
            } else {
                this.updateRange(this.defaultAutoRange);
            }
        }
    }

    @Override
    public void configureAsZAxis(XYZPlot plot) {
        this.configuredType = ValueAxis3DType.Z;
        if (this.autoAdjustRange) {
            Range zRange = plot.getRenderer().findZRange(plot.getDataset());
            if (zRange != null) {
                this.updateRange(this.adjustedDataRange(zRange));
            } else {
                this.updateRange(this.defaultAutoRange);
            }
        }
    }

    protected abstract Range adjustedDataRange(Range var1);

    @Override
    public ValueMarker getMarker(String key) {
        return this.valueMarkers.get(key);
    }

    public void setMarker(String key, ValueMarker marker) {
        ValueMarker existing = this.valueMarkers.get(key);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.valueMarkers.put(key, marker);
        marker.addChangeListener(this);
        this.fireChangeEvent(false);
    }

    public Map<String, ValueMarker> getMarkers() {
        return new LinkedHashMap<String, ValueMarker>(this.valueMarkers);
    }

    @Override
    public List<MarkerData> generateMarkerData() {
        ArrayList<MarkerData> result = new ArrayList<MarkerData>();
        Range range = this.getRange();
        for (Map.Entry<String, ValueMarker> entry : this.valueMarkers.entrySet()) {
            MarkerData markerData;
            ValueMarker vm = entry.getValue();
            if (!range.intersects(vm.getRange())) continue;
            if (vm instanceof NumberMarker) {
                NumberMarker nm = (NumberMarker)vm;
                markerData = new MarkerData(entry.getKey(), range.percent(nm.getValue()));
                markerData.setLabelAnchor(nm.getLabel() != null ? nm.getLabelAnchor() : null);
            } else if (vm instanceof RangeMarker) {
                RangeMarker rm = (RangeMarker)vm;
                double startValue = rm.getStart().getValue();
                boolean startPegged = false;
                if (!range.contains(startValue)) {
                    startValue = range.peggedValue(startValue);
                    startPegged = true;
                }
                double startPos = range.percent(startValue);
                double endValue = rm.getEnd().getValue();
                boolean endPegged = false;
                if (!range.contains(endValue)) {
                    endValue = range.peggedValue(endValue);
                    endPegged = true;
                }
                double endPos = range.percent(endValue);
                markerData = new MarkerData(entry.getKey(), startPos, startPegged, endPos, endPegged);
                markerData.setLabelAnchor(rm.getLabel() != null ? rm.getLabelAnchor() : null);
            } else {
                throw new RuntimeException("Unrecognised marker.");
            }
            result.add(markerData);
        }
        return result;
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        for (ValueMarker marker : this.valueMarkers.values()) {
            marker.receive(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractValueAxis3D)) {
            return false;
        }
        AbstractValueAxis3D that = (AbstractValueAxis3D)obj;
        if (!this.range.equals(that.range)) {
            return false;
        }
        if (this.autoAdjustRange != that.autoAdjustRange) {
            return false;
        }
        if (this.lowerMargin != that.lowerMargin) {
            return false;
        }
        if (this.upperMargin != that.upperMargin) {
            return false;
        }
        if (!this.defaultAutoRange.equals(that.defaultAutoRange)) {
            return false;
        }
        if (this.tickLabelOffset != that.tickLabelOffset) {
            return false;
        }
        if (this.tickLabelFactor != that.tickLabelFactor) {
            return false;
        }
        if (!this.tickLabelOrientation.equals((Object)that.tickLabelOrientation)) {
            return false;
        }
        if (this.tickMarkLength != that.tickMarkLength) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.tickMarkPaint, that.tickMarkPaint)) {
            return false;
        }
        if (!this.tickMarkStroke.equals(that.tickMarkStroke)) {
            return false;
        }
        return super.equals(obj);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.tickMarkPaint, stream);
        SerialUtils.writeStroke(this.tickMarkStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.tickMarkPaint = SerialUtils.readPaint(stream);
        this.tickMarkStroke = SerialUtils.readStroke(stream);
    }
}

