/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.Chart3DHints;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.axis.Axis3D;
import org.jfree.chart3d.axis.Axis3DChangeEvent;
import org.jfree.chart3d.axis.Axis3DChangeListener;
import org.jfree.chart3d.axis.TickData;
import org.jfree.chart3d.graphics2d.TextAnchor;
import org.jfree.chart3d.graphics3d.RenderedElement;
import org.jfree.chart3d.graphics3d.RenderingInfo;
import org.jfree.chart3d.graphics3d.internal.Utils2D;
import org.jfree.chart3d.interaction.InteractiveElementType;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.internal.TextUtils;
import org.jfree.chart3d.marker.MarkerChangeEvent;
import org.jfree.chart3d.marker.MarkerChangeListener;

public abstract class AbstractAxis3D
implements Axis3D,
MarkerChangeListener,
Serializable {
    public static final Font DEFAULT_LABEL_FONT = new Font("Dialog", 1, 12);
    public static final Color DEFAULT_LABEL_COLOR = Color.BLACK;
    public static final double DEFAULT_LABEL_OFFSET = 10.0;
    public static final Font DEFAULT_TICK_LABEL_FONT = new Font("Dialog", 0, 12);
    public static final Color DEFAULT_TICK_LABEL_COLOR = Color.BLACK;
    public static final Stroke DEFAULT_LINE_STROKE = new BasicStroke(0.0f);
    public static final Color DEFAULT_LINE_COLOR = Color.GRAY;
    private boolean visible = true;
    private String label;
    private Font labelFont;
    private Color labelColor;
    private double labelOffset;
    private transient Stroke lineStroke;
    private Color lineColor;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private Color tickLabelColor;
    private final transient EventListenerList listenerList;

    public AbstractAxis3D(String label) {
        this.label = label;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelColor = DEFAULT_LABEL_COLOR;
        this.labelOffset = 10.0;
        this.lineStroke = DEFAULT_LINE_STROKE;
        this.lineColor = DEFAULT_LINE_COLOR;
        this.tickLabelsVisible = true;
        this.tickLabelFont = DEFAULT_TICK_LABEL_FONT;
        this.tickLabelColor = DEFAULT_TICK_LABEL_COLOR;
        this.listenerList = new EventListenerList();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireChangeEvent(false);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent(false);
    }

    @Override
    public Font getLabelFont() {
        return this.labelFont;
    }

    @Override
    public void setLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.labelFont = font;
        this.fireChangeEvent(false);
    }

    @Override
    public Color getLabelColor() {
        return this.labelColor;
    }

    @Override
    public void setLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.labelColor = color;
        this.fireChangeEvent(false);
    }

    public double getLabelOffset() {
        return this.labelOffset;
    }

    public void setLabelOffset(double offset) {
        this.labelOffset = offset;
        this.fireChangeEvent(false);
    }

    public Stroke getLineStroke() {
        return this.lineStroke;
    }

    public void setLineStroke(Stroke stroke) {
        Args.nullNotPermitted(stroke, "stroke");
        this.lineStroke = stroke;
        this.fireChangeEvent(false);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.lineColor = color;
        this.fireChangeEvent(false);
    }

    public boolean getTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean visible) {
        this.tickLabelsVisible = visible;
        this.fireChangeEvent(false);
    }

    @Override
    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    @Override
    public void setTickLabelFont(Font font) {
        Args.nullNotPermitted(font, "font");
        this.tickLabelFont = font;
        this.fireChangeEvent(false);
    }

    @Override
    public Color getTickLabelColor() {
        return this.tickLabelColor;
    }

    @Override
    public void setTickLabelColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.tickLabelColor = color;
        this.fireChangeEvent(false);
    }

    @Override
    public abstract void receive(ChartElementVisitor var1);

    protected Shape drawAxisLabel(String label, Graphics2D g2, Line2D axisLine, Point2D opposingPt, double offset, RenderingInfo info, boolean hinting) {
        Args.nullNotPermitted(label, "label");
        Args.nullNotPermitted(g2, "g2");
        Args.nullNotPermitted(axisLine, "axisLine");
        Args.nullNotPermitted(opposingPt, "opposingPt");
        g2.setFont(this.getLabelFont());
        g2.setPaint(this.getLabelColor());
        Line2D labelPosLine = Utils2D.createPerpendicularLine(axisLine, 0.5, offset, opposingPt);
        double theta = Utils2D.calculateTheta(axisLine);
        if (theta < -1.5707963267948966) {
            theta += Math.PI;
        }
        if (theta > 1.5707963267948966) {
            theta -= Math.PI;
        }
        if (hinting) {
            HashMap<String, CallSite> m = new HashMap<String, CallSite>();
            m.put("ref", (CallSite)((Object)("{\"type\": \"axisLabel\", \"axis\": \"" + this.axisStr() + "\", \"label\": \"" + this.getLabel() + "\"}")));
            g2.setRenderingHint(Chart3DHints.KEY_BEGIN_ELEMENT, m);
        }
        Shape bounds = TextUtils.drawRotatedString(this.getLabel(), g2, (float)labelPosLine.getX2(), (float)labelPosLine.getY2(), TextAnchor.CENTER, theta, TextAnchor.CENTER);
        if (hinting) {
            g2.setRenderingHint(Chart3DHints.KEY_END_ELEMENT, true);
        }
        if (info != null) {
            RenderedElement labelElement = new RenderedElement((Object)InteractiveElementType.AXIS_LABEL, bounds);
            labelElement.setProperty("axis", this.axisStr());
            labelElement.setProperty("label", this.getLabel());
            info.addOffsetElement(labelElement);
        }
        return bounds;
    }

    protected abstract String axisStr();

    @Override
    public abstract void draw(Graphics2D var1, Point2D var2, Point2D var3, Point2D var4, List<TickData> var5, RenderingInfo var6, boolean var7);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractAxis3D)) {
            return false;
        }
        AbstractAxis3D that = (AbstractAxis3D)obj;
        if (this.visible != that.visible) {
            return false;
        }
        if (!ObjectUtils.equals(this.label, that.label)) {
            return false;
        }
        if (!this.labelFont.equals(that.labelFont)) {
            return false;
        }
        if (!this.labelColor.equals(that.labelColor)) {
            return false;
        }
        if (!this.lineStroke.equals(that.lineStroke)) {
            return false;
        }
        if (!this.lineColor.equals(that.lineColor)) {
            return false;
        }
        if (this.tickLabelsVisible != that.tickLabelsVisible) {
            return false;
        }
        if (!this.tickLabelFont.equals(that.tickLabelFont)) {
            return false;
        }
        return this.tickLabelColor.equals(that.tickLabelColor);
    }

    public int hashCode() {
        int hash = 5;
        hash = 83 * hash + (this.visible ? 1 : 0);
        hash = 83 * hash + ObjectUtils.hashCode(this.label);
        hash = 83 * hash + ObjectUtils.hashCode(this.labelFont);
        hash = 83 * hash + ObjectUtils.hashCode(this.labelColor);
        hash = 83 * hash + ObjectUtils.hashCode(this.lineStroke);
        hash = 83 * hash + ObjectUtils.hashCode(this.lineColor);
        hash = 83 * hash + (this.tickLabelsVisible ? 1 : 0);
        hash = 83 * hash + ObjectUtils.hashCode(this.tickLabelFont);
        hash = 83 * hash + ObjectUtils.hashCode(this.tickLabelColor);
        return hash;
    }

    @Override
    public void addChangeListener(Axis3DChangeListener listener) {
        this.listenerList.add(Axis3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Axis3DChangeListener listener) {
        this.listenerList.remove(Axis3DChangeListener.class, listener);
    }

    public void notifyListeners(Axis3DChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Axis3DChangeListener.class) continue;
            ((Axis3DChangeListener)listeners[i + 1]).axisChanged(event);
        }
    }

    protected void fireChangeEvent(boolean requiresWorldUpdate) {
        this.notifyListeners(new Axis3DChangeEvent(this, requiresWorldUpdate));
    }

    @Override
    public void markerChanged(MarkerChangeEvent event) {
        this.fireChangeEvent(false);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writeStroke(this.lineStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.lineStroke = SerialUtils.readStroke(stream);
    }
}

