/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0093\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n*\u0001\u0018\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001vB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003J\u001c\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002J \u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u001d2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u001f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020!2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020$2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020&2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010'\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020(2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J(\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020\u0012H\u0002J*\u00106\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010*\u001a\u00020\u0012H\u0002J\u001a\u00108\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\b\u00107\u001a\u0004\u0018\u000101H\u0002J \u00109\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020:2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010;\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020<2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010=\u001a\u00020>2\u0006\u0010\u0011\u001a\u00020<2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020@H\u0002J \u0010C\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020D2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J \u0010E\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020F2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J0\u0010G\u001a\b\u0012\u0002\b\u0003\u0018\u00010H2\n\u0010I\u001a\u0006\u0012\u0002\b\u00030J2\u0006\u0010K\u001a\u00020L2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NH\u0002J&\u0010P\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030R0Q\u0018\u00010H2\n\u0010I\u001a\u0006\u0012\u0002\b\u00030JH\u0002J \u0010S\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020T2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020Q2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020W0Q2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J \u0010X\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010Y\u001a\u00020Z2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\u001e\u0010[\u001a\u0004\u0018\u0001032\n\u0010\\\u001a\u0006\u0012\u0002\b\u00030J2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010]\u001a\u0004\u0018\u0001032\u0006\u0010^\u001a\u00020_2\u0006\u00107\u001a\u00020`H\u0002J\u0012\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u00020\u0003H\u0002J\"\u0010d\u001a\u0004\u0018\u0001032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010e\u001a\u00020\u00032\u0006\u0010f\u001a\u00020bH\u0002J*\u0010g\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010h\u001a\u0004\u0018\u0001012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010i\u001a\u00020jH\u0002J(\u0010k\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010h\u001a\u0004\u0018\u0001012\u0006\u0010i\u001a\u00020j2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J$\u0010l\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010h\u001a\u00020m2\u0006\u0010i\u001a\u00020j2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0018\u0010n\u001a\u0006\u0012\u0002\b\u00030H*\u00020m2\u0006\u0010i\u001a\u00020jH\u0002J\b\u0010o\u001a\u00020\u0015H\u0002J&\u0010p\u001a\b\u0012\u0004\u0012\u0002Hq0H\"\u0004\b\u0000\u0010q*\b\u0012\u0004\u0012\u0002Hq0R2\u0006\u0010i\u001a\u00020jH\u0002Jd\u0010p\u001a\b\u0012\u0004\u0012\u0002Hq0H\"\u0004\b\u0000\u0010q*\b\u0012\u0004\u0012\u0002Hq0R2\b\b\u0002\u0010.\u001a\u00020\u00152\b\b\u0002\u0010r\u001a\u00020\u00152\b\b\u0002\u0010s\u001a\u00020\u00152\b\b\u0002\u0010t\u001a\u00020\u00152\b\b\u0002\u0010,\u001a\u00020\u00152\b\b\u0002\u0010-\u001a\u00020\u00152\b\b\u0002\u0010u\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019\u00a8\u0006w"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "evaluate", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expectedType", "shouldSkipComplexBooleanValue", "", "constant", "stringExpressionEvaluator", "org/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "visitConstantExpression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitParenthesizedExpression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitLabeledExpression", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitStringTemplateExpression", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "isStandaloneOnlyConstant", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitCollectionLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "evaluateCall", "callExpression", "receiverExpression", "usesVariableAsConstant", "usesNonConstValAsConstant", "canBeUsedInAnnotation", "isPureConstant", "evaluateUnaryAndCheck", "", "receiver", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "name", "", "evaluateBinaryAndCheck", "parameter", "isDivisionByZero", "visitUnaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitSimpleNameExpression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "reportInlineConst", "", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "isPropertyCompileTimeConstant", "descriptor", "visitQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "createConstantValueForUnsignedTypeConstructor", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "call", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "representation", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/types/SimpleType;", "createConstantValueForArrayFunctionCall", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "visitClassLiteralExpression", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "resolveArguments", "valueArguments", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createOperationArgumentForReceiver", "resolvedCall", "createOperationArgumentForFirstParameter", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "getCompileTimeType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "c", "createOperationArgument", "parameterType", "compileTimeType", "createConstant", "value", "parameters", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "createCompileTimeConstant", "createIntegerCompileTimeConstant", "", "createSimpleIntCompileTimeConst", "checkAccessibilityOfUnsignedTypes", "wrap", "T", "isPure", "isUnsigned", "isUnsignedLong", "isConvertableConstVal", "OperationArgument", "frontend"})
@SourceDebugExtension(value={"SMAP\nConstantExpressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,1289:1\n1368#2:1290\n1454#2,5:1291\n1557#2:1296\n1628#2,3:1297\n1755#2,3:1300\n1755#2,3:1303\n142#3:1306\n142#3:1307\n*S KotlinDebug\n*F\n+ 1 ConstantExpressionEvaluator.kt\norg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor\n*L\n962#1:1290\n962#1:1291,5\n967#1:1296\n967#1:1297,3\n969#1:1300,3\n970#1:1303,3\n770#1:1306\n781#1:1307\n*E\n"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)constantExpressionEvaluator, (String)"constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.languageVersionSettings = this.constantExpressionEvaluator.getLanguageVersionSettings$frontend();
        this.builtIns = this.constantExpressionEvaluator.getModule$frontend().getBuiltIns();
        this.inlineConstTracker = this.constantExpressionEvaluator.getInlineConstTracker$frontend() instanceof InlineConstTracker.DoNothing ? null : this.constantExpressionEvaluator.getInlineConstTracker$frontend();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            {
                this.this$0 = $receiver;
            }

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue = compileTimeConstant.toConstantValue(simpleType);
                if (ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constantValue)) {
                    return null;
                }
                ConstantValue<?> constantValue2 = constantValue;
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? new StringValue("null") : new StringValue(String.valueOf(constantValue.boxedValue())), compileTimeConstant.getParameters());
            }

            public final TypedCompileTimeConstant<String> evaluate(KtStringTemplateEntry entry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(KtStringTemplateEntryWithExpression entry, Void data) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                KtExpression expression2 = ktExpression;
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(expression2, ConstantExpressionEvaluatorVisitor.access$getBuiltIns$p(this.this$0).getStringType());
                if (compileTimeConstant != null) {
                    CompileTimeConstant<?> it = compileTimeConstant;
                    boolean bl = false;
                    typedCompileTimeConstant = this.createStringConstant(it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(KtLiteralStringTemplateEntry entry, Void data) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String string2 = entry.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, 127, null);
            }

            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(KtEscapeStringTemplateEntry entry, Void data) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String string2 = entry.getUnescapedValue();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUnescapedValue(...)");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, 127, null);
            }
        };
    }

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression2, @Nullable KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression2, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
            kotlinType = simpleType;
        }
        if ((compileTimeConstant = (CompileTimeConstant)expression2.accept(ktVisitor, kotlinType)) != null) {
            if (this.shouldSkipComplexBooleanValue(expression2, compileTimeConstant)) {
                return null;
            }
            if (compileTimeConstant instanceof TypedCompileTimeConstant && TypeUtilsKt.isGenericArrayOfTypeParameter(((TypedCompileTimeConstant)compileTimeConstant).getType())) {
                return compileTimeConstant;
            }
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean shouldSkipComplexBooleanValue(KtExpression expression2, CompileTimeConstant<?> constant) {
        if (!ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression2, constant)) {
            return false;
        }
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return true;
        }
        PsiElement parent2 = expression2.getParent();
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (parent2 instanceof KtWhenConditionWithExpression || parent2 instanceof KtContainerNode && (((KtContainerNode)parent2).getParent() instanceof KtWhileExpression || ((KtContainerNode)parent2).getParent() instanceof KtDoWhileExpression)) {
            SimpleType simpleType = this.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
            ConstantValue<?> constantValue = constant.toConstantValue(simpleType);
            PsiElement psiElement = expression2;
            Object obj = constantValue.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
            this.trace.report(Errors.NON_TRIVIAL_BOOLEAN_CONSTANT.on((KtExpression)psiElement, (Boolean)obj));
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression2, @Nullable KotlinType expectedType) {
        boolean isIntegerConstant;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        String string2 = expression2.getText();
        if (string2 == null) {
            return null;
        }
        String text = string2;
        IElementType iElementType = expression2.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType nodeElementType = iElementType;
        if (Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new NullValue(), false, false, false, false, false, false, false, 127, null);
        }
        IElementType iElementType2 = nodeElementType;
        if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            serializable = ParseUtilsKt.parseNumericLiteral(text, nodeElementType);
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            serializable = Boolean.valueOf(ParseUtilsKt.parseBoolean(text));
        } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtNodeTypes.CHARACTER_CONSTANT)) {
            serializable = CompileTimeConstantChecker.parseChar(expression2);
        } else {
            throw new IllegalArgumentException("Unsupported constant: " + expression2);
        }
        if (serializable == null) {
            return null;
        }
        Serializable result2 = serializable;
        if (result2 instanceof Double) {
            if (Double.isInfinite(((Number)result2).doubleValue())) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (((Number)result2).doubleValue() == 0.0 && !TypeConversionUtil.isFPZero(text)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        if (result2 instanceof Float) {
            if (Float.isInfinite(((Number)result2).floatValue())) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression2)));
            }
            if (((Number)result2).floatValue() == 0.0f && !TypeConversionUtil.isFPZero(text)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression2)));
            }
        }
        boolean isUnsignedLong = (isIntegerConstant = Intrinsics.areEqual((Object)nodeElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) && ParseUtilsKt.hasUnsignedLongSuffix(text);
        boolean isUnsigned = isUnsignedLong || ParseUtilsKt.hasUnsignedSuffix(text);
        boolean isTyped = isUnsigned || ParseUtilsKt.hasLongSuffix(text);
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isTyped, isUnsigned, isUnsignedLong, false, false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression2);
        if (deparenthesizedExpression != null && !Intrinsics.areEqual((Object)deparenthesizedExpression, (Object)expression2)) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression baseExpression = expression2.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        boolean usesVariableAsConstant = false;
        boolean usesNonConstantVariableAsConstant = false;
        for (KtStringTemplateEntry entry : expression2.getEntries()) {
            Intrinsics.checkNotNull((Object)entry);
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(entry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        return !interupted ? this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, false, false, false, usesVariableAsConstant, usesNonConstantVariableAsConstant, false)) : null;
    }

    private final boolean isStandaloneOnlyConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        if (compileTimeConstant == null) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(compileTimeConstant);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeft(...)");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType);
        if (compileTimeConstant != null && expectedType != null && !TypeUtils.noExpectedType(expectedType)) {
            KotlinType kotlinType;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType);
            } else {
                throw new IllegalStateException("Unexpected compileTimeConstant class: " + compileTimeConstant.getClass().getCanonicalName());
            }
            KotlinType constantType = kotlinType;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        IElementType iElementType = expression2.getOperationToken();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
        IElementType operationToken = iElementType;
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BOOLEAN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, (String)"BOOLEAN_OPERATIONS");
        if (((Map)immutableBiMap).containsKey(operationToken)) {
            boolean bl;
            SimpleType simpleType = this.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getBooleanType(...)");
            SimpleType booleanType = simpleType;
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(leftExpression, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            KtExpression ktExpression2 = expression2.getRight();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression rightExpression = ktExpression2;
            CompileTimeConstant<?> compileTimeConstant2 = this.evaluate(rightExpression, booleanType);
            if (compileTimeConstant2 == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant2;
            Object leftValue = leftConstant.getValue(booleanType);
            Object rightValue = rightConstant.getValue(booleanType);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType2 = operationToken;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)KtTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, false, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant(), false));
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktOperationReferenceExpression, (String)"getOperationReference(...)");
        return this.evaluateCall(ktOperationReferenceExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        ResolvedCall resolvedCall2 = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.COLLECTION_LITERAL_CALL, expression2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.createConstantValueForArrayFunctionCall(resolvedCall3);
    }

    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType) {
        KtElement ktElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!KotlinBuiltIns.isUnderKotlinPackage(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        Name name2 = ((Named)resolvedCall3.getResultingDescriptor()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name resultingDescriptorName = name2;
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        if (this.isStandaloneOnlyConstant(argumentForReceiver.getExpression())) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            Object object = this.evaluateUnaryAndCheck(argumentForReceiver, string2, callExpression);
            if (object == null) {
                return null;
            }
            Object result2 = object;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            boolean isCharCode = argumentForReceiver.getCtcType() == CompileTimeType.CHAR && Intrinsics.areEqual((Object)resultingDescriptorName, (Object)StandardNames.CHAR_CODE);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && !isCharCode && isArgumentPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)entry.getKey();
            ResolvedValueArgument argument = (ResolvedValueArgument)entry.getValue();
            Intrinsics.checkNotNull((Object)argument);
            Intrinsics.checkNotNull((Object)parameter);
            OperationArgument operationArgument2 = this.createOperationArgumentForFirstParameter(argument, parameter);
            if (operationArgument2 == null) {
                return null;
            }
            OperationArgument argumentForParameter = operationArgument2;
            if (this.isStandaloneOnlyConstant(argumentForParameter.getExpression())) {
                return null;
            }
            String string3 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
            if (this.isDivisionByZero(string3, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                Intrinsics.checkNotNull((Object)ktExpression);
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                if (ConstantExpressionEvaluatorKt.isIntegerType(argumentForReceiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(argumentForParameter.getValue()) || !this.languageVersionSettings.supportsFeature(LanguageFeature.DivisionByZeroInConstantExpressions)) {
                    return ConstantExpressionEvaluatorVisitor.wrap$default(this, ErrorValue.Companion.create("Division by zero"), false, false, false, false, false, false, false, 127, null);
                }
            }
            String string4 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
            Object object = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string4, callExpression);
            if (object == null) {
                return null;
            }
            Object result3 = object;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters = new CompileTimeConstant.Parameters(canBeUsedInAnnotation, areArgumentsPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false);
            Name name3 = resultingDescriptorName;
            if (Intrinsics.areEqual((Object)name3, (Object)OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters) : null;
            } else if (Intrinsics.areEqual((Object)name3, (Object)OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression2) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression2, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name2, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateUnaryAndCheck(name2, receiver.getCtcType(), receiver.getValue(), () -> ConstantExpressionEvaluatorVisitor.evaluateUnaryAndCheck$lambda$0(this, callExpression));
    }

    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name2, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateBinaryAndCheck(name2, receiver.getCtcType(), receiver.getValue(), parameter.getCtcType(), parameter.getValue(), () -> ConstantExpressionEvaluatorVisitor.evaluateBinaryAndCheck$lambda$1(this, callExpression));
    }

    private final boolean isDivisionByZero(String name2, Object parameter) {
        return ConstantExpressionEvaluatorKt.access$getDIVISION_OPERATION_NAMES$p().contains(name2) && ConstantExpressionEvaluatorKt.access$isZero(parameter);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression ktExpression = expression2.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression2.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        return this.evaluateCall(ktSimpleNameExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2, @Nullable KotlinType expectedType) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression2);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)declarationDescriptor));
            if (classId == null) {
                return null;
            }
            ClassId enumClassId = classId;
            Name name2 = enumDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new EnumValue(enumClassId, name2), false, false, false, false, false, false, false, 127, null);
        }
        VariableDescriptor variableDescriptor2 = variableDescriptor = enumDescriptor instanceof VariableDescriptor ? (VariableDescriptor)enumDescriptor : null;
        if (variableDescriptor != null && this.isPropertyCompileTimeConstant(variableDescriptor)) {
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
            if (!DescriptorUtilsKt.isCompanionObject(declarationDescriptor)) {
                this.reportInlineConst(expression2, variableDescriptor);
            }
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null) {
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof VariableDescriptor) {
                if (callableDescriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)callableDescriptor2).getModality() != Modality.FINAL) {
                    return null;
                }
                boolean isConvertableConstVal = ((VariableDescriptor)callableDescriptor2).isConst() && ImplicitIntegerCoercion.INSTANCE.isEnabledFor(callableDescriptor2, this.languageVersionSettings) && ((VariableDescriptor)callableDescriptor2).getCompileTimeInitializer() instanceof IntValue;
                ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor2).getCompileTimeInitializer();
                return constantValue != null ? this.wrap(constantValue, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor2), false, false, false, true, !((VariableDescriptor)callableDescriptor2).isConst(), isConvertableConstVal)) : null;
            }
        }
        return null;
    }

    private final void reportInlineConst(KtSimpleNameExpression expression2, VariableDescriptor variableDescriptor) {
        String string2;
        if (this.inlineConstTracker == null) {
            return;
        }
        Object object = expression2.getContainingFile().getVirtualFile();
        if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
            return;
        }
        Object filePath = object;
        String name2 = expression2.getReferencedName();
        String constType = variableDescriptor.getType().toString();
        Object object2 = DescriptorUtilKt.containingPackage(variableDescriptor);
        if (object2 == null || (object2 = ((FqName)object2).toString()) == null) {
            return;
        }
        Object containingPackage = object2;
        DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        String string3 = DescriptorUtilsKt.getFqNameSafe(declarationDescriptor).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        String fqName = string3;
        if (StringsKt.startsWith$default((String)fqName, (String)((String)containingPackage + '.'), (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append((String)containingPackage).append('.');
            String string4 = fqName.substring(((String)containingPackage).length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string2 = stringBuilder.append(StringsKt.replace$default((String)string4, (String)".", (String)"$", (boolean)false, (int)4, null)).toString();
        } else {
            string2 = StringsKt.replace$default((String)fqName, (String)".", (String)"$", (boolean)false, (int)4, null);
        }
        String owner = string2;
        this.inlineConstTracker.report((String)filePath, owner, name2, constType);
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor) {
        if (descriptor.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor)) {
            KotlinType kotlinType = descriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            return ConstUtilKt.canBeUsedForConstVal(kotlinType);
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression2, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> result2;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression receiverExpression = expression2.getReceiverExpression();
            return this.evaluateCall(calleeExpression, receiverExpression, expectedType);
        }
        if (selectorExpression instanceof KtSimpleNameExpression && (result2 = this.evaluateCall(selectorExpression, expression2.getReceiverExpression(), expectedType)) != null) {
            return result2;
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        CallableDescriptor callableDescriptor = call2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        CallableDescriptor resultingDescriptor = callableDescriptor;
        if (CompileTimeConstantUtils.isArrayFunctionCall(call2)) {
            return this.createConstantValueForArrayFunctionCall(call2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            CompileTimeConstant compileTimeConstant;
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getConstructedClass(...)");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$frontend(call2, this.trace), SourceElement.NO_SOURCE);
                compileTimeConstant = ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor), false, false, false, false, false, false, false, 127, null);
            } else if (InlineClassesUtilsKt.isInlineClass(classDescriptor2) && UnsignedTypes.INSTANCE.isUnsignedClass(classDescriptor2)) {
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)resultingDescriptor;
                InlineClassRepresentation<SimpleType> inlineClassRepresentation = DescriptorUtilsKt.getInlineClassRepresentation(classDescriptor2);
                Intrinsics.checkNotNull(inlineClassRepresentation);
                compileTimeConstant = this.createConstantValueForUnsignedTypeConstructor(call2, constructorDescriptor, inlineClassRepresentation);
            } else {
                compileTimeConstant = null;
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final TypedCompileTimeConstant<?> createConstantValueForUnsignedTypeConstructor(ResolvedCall<?> call2, ConstructorDescriptor constructorDescriptor, InlineClassRepresentation<SimpleType> representation) {
        if (!constructorDescriptor.isPrimary()) {
            return null;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = call2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = map;
        if (valueArguments.size() > 1) {
            return null;
        }
        Object object = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)valueArguments.values());
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull((List)object)) == null) {
            return null;
        }
        Object argument = object;
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        SimpleType underlyingType = representation.getUnderlyingType();
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(argumentExpression, underlyingType);
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 == null || (compileTimeConstant2 = compileTimeConstant2.toConstantValue(underlyingType)) == null) {
            return null;
        }
        CompileTimeConstant<?> evaluatedArgument = compileTimeConstant2;
        UnsignedValueConstant<?> unsignedValueConstant = ConstantValueFactory.INSTANCE.createUnsignedValue((ConstantValue<?>)((Object)evaluatedArgument));
        if (unsignedValueConstant == null) {
            return null;
        }
        UnsignedValueConstant<?> unsignedValue = unsignedValueConstant;
        return this.wrap((ConstantValue)unsignedValue, compileTimeConstant.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final TypedCompileTimeConstant<List<ConstantValue<?>>> createConstantValueForArrayFunctionCall(ResolvedCall<?> call2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
        Object object;
        block10: {
            boolean bl7;
            Iterable $this$any$iv;
            boolean $i$f$any;
            List arguments;
            block9: {
                Collection collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                KotlinType kotlinType = call2.getResultingDescriptor().getReturnType();
                if (kotlinType == null) {
                    return null;
                }
                KotlinType returnType = kotlinType;
                KotlinType kotlinType2 = this.builtIns.getArrayElementType(returnType);
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getArrayElementType(...)");
                KotlinType componentType = kotlinType2;
                Iterable $this$flatMap$iv = call2.getValueArguments().values();
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl8 = false;
                    List<ValueArgument> list = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
                    Iterable list$iv$iv = this.resolveArguments(list, componentType);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                arguments = (List)destination$iv$iv;
                List evaluatedArguments = CollectionsKt.filterNotNull((Iterable)arguments);
                Iterable $i$f$flatMap22 = evaluatedArguments;
                object = ConstantValueFactory.INSTANCE;
                constantExpressionEvaluatorVisitor = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompileTimeConstant bl8 = (CompileTimeConstant)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl9 = false;
                    collection.add(it.toConstantValue(componentType));
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = evaluatedArguments;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, returnType);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompileTimeConstant it = (CompileTimeConstant)element$iv;
                        boolean bl10 = false;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl7 = true;
                        break block9;
                    }
                    bl7 = false;
                }
            }
            bl2 = bl7;
            $this$any$iv = arguments;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CompileTimeConstant it = (CompileTimeConstant)element$iv;
                    boolean bl11 = false;
                    if (!(it == null || it.getUsesNonConstValAsConstant())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl12 = bl;
        return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl5, bl6, bl2, bl12, false, 79, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression2, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        KotlinType kotlinType = this.trace.getType(expression2);
        Intrinsics.checkNotNull((Object)kotlinType);
        KotlinType kClassType = kotlinType;
        if (KotlinTypeKt.isError(kClassType)) {
            return null;
        }
        ClassifierDescriptor descriptor = kClassType.getConstructor().getDeclarationDescriptor();
        if (!(descriptor instanceof ClassDescriptor) || !KotlinBuiltIns.isKClass((ClassDescriptor)descriptor)) {
            return null;
        }
        Object object = (TypeProjection)CollectionsKt.singleOrNull(kClassType.getArguments());
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object type2 = object;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitTypeParametersInClassLiteralsInAnnotationArguments) && ConstantExpressionEvaluator.Companion.isTypeParameterOrArrayOfTypeParameter$frontend((KotlinType)type2)) {
            return null;
        }
        ConstantValue<?> constantValue = KClassValue.Companion.create((KotlinType)type2);
        return constantValue != null ? ConstantExpressionEvaluatorVisitor.wrap$default(this, constantValue, false, false, false, false, false, false, false, 127, null) : null;
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments, KotlinType expectedType) {
        ArrayList constants = new ArrayList();
        for (ValueArgument valueArgument : valueArguments) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            constants.add(this.evaluate(argumentExpression, expectedType));
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression2) {
        KotlinType kotlinType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType;
        CompileTimeType compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression2, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        CompileTimeType compileTimeType = this.getCompileTimeType(kotlinType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType argumentCompileTimeType = compileTimeType;
        List<ValueArgument> list = argument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
        List<ValueArgument> arguments = list;
        if (arguments.size() != 1) {
            return null;
        }
        KtExpression ktExpression = ((ValueArgument)CollectionsKt.first(arguments)).getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        return this.createOperationArgument(argumentExpression, kotlinType2, argumentCompileTimeType);
    }

    private final CompileTimeType getCompileTimeType(KotlinType c) {
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getIntType()) ? CompileTimeType.INT : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getByteType()) ? CompileTimeType.BYTE : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getShortType()) ? CompileTimeType.SHORT : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getLongType()) ? CompileTimeType.LONG : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getDoubleType()) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getFloatType()) ? CompileTimeType.FLOAT : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getCharType()) ? CompileTimeType.CHAR : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getBooleanType()) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getStringType()) ? CompileTimeType.STRING : (Intrinsics.areEqual((Object)kotlinType, (Object)this.builtIns.getAnyType()) ? CompileTimeType.ANY : null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression2, KotlinType parameterType, CompileTimeType compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression2, this.trace, parameterType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 instanceof TypedCompileTimeConstant && !TypeUtilsKt.isSubtypeOf(((TypedCompileTimeConstant)compileTimeConstant2).getType(), parameterType)) {
            return null;
        }
        ConstantValue<?> constantValue = compileTimeConstant2.toConstantValue(parameterType);
        Object object = compileTimeType == CompileTimeType.ANY ? constantValue.boxedValue() : constantValue.getValue();
        if (object == null) {
            return null;
        }
        Object evaluationResult = object;
        return new OperationArgument(evaluationResult, compileTimeType, expression2);
    }

    private final CompileTimeConstant<?> createConstant(Object value2, KotlinType expectedType, CompileTimeConstant.Parameters parameters) {
        if (parameters.isPure() || parameters.isUnsignedNumberLiteral()) {
            KotlinType kotlinType = expectedType;
            if (kotlinType == null) {
                SimpleType simpleType = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"NO_EXPECTED_TYPE");
                kotlinType = simpleType;
            }
            return this.createCompileTimeConstant(value2, parameters, kotlinType);
        }
        ConstantValue constantValue = ConstantValueFactory.createConstantValue$default(ConstantValueFactory.INSTANCE, value2, null, 2, null);
        return constantValue != null ? this.wrap(constantValue, parameters) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value2, CompileTimeConstant.Parameters parameters, KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value2;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Number");
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)value2).longValue(), parameters, expectedType);
        } else {
            ConstantValue constantValue = ConstantValueFactory.createConstantValue$default(ConstantValueFactory.INSTANCE, value2, null, 2, null);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value2, CompileTimeConstant.Parameters parameters, KotlinType expectedType) {
        if (parameters.isUnsignedNumberLiteral() && !this.checkAccessibilityOfUnsignedTypes()) {
            return new UnsignedErrorValueTypeConstant(value2, this.constantExpressionEvaluator.getModule$frontend(), parameters);
        }
        if (parameters.isUnsignedLongNumberLiteral()) {
            return this.wrap(new ULongValue(value2), parameters);
        }
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            return CompileTimeConstantKt.createIntegerValueTypeConstant(value2, this.constantExpressionEvaluator.getModule$frontend(), parameters, this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference));
        }
        ConstantValue<?> integerValue = ConstantValueFactory.INSTANCE.createIntegerConstantValue(value2, expectedType, parameters.isUnsignedNumberLiteral());
        if (integerValue != null) {
            return this.wrap(integerValue, parameters);
        }
        return this.createSimpleIntCompileTimeConst(value2, parameters);
    }

    private final TypedCompileTimeConstant<?> createSimpleIntCompileTimeConst(long $this$createSimpleIntCompileTimeConst, CompileTimeConstant.Parameters parameters) {
        long value2 = $this$createSimpleIntCompileTimeConst;
        return this.wrap(parameters.isUnsignedNumberLiteral() ? (ConstantValue)(value2 == ConstantValueFactoryKt.fromUIntToLong((int)value2) ? (UnsignedValueConstant)new UIntValue((int)value2) : (UnsignedValueConstant)new ULongValue(value2)) : (ConstantValue)(value2 == (long)((int)value2) ? (IntegerValueConstant)new IntValue((int)value2) : (IntegerValueConstant)new LongValue(value2)), parameters);
    }

    private final boolean checkAccessibilityOfUnsignedTypes() {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.constantExpressionEvaluator.getModule$frontend(), StandardNames.FqNames.uInt);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor uInt = classDescriptor;
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(uInt, this.languageVersionSettings);
        return !(accessibility instanceof SinceKotlinAccessibility.NotAccessible);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, CompileTimeConstant.Parameters parameters) {
        return new TypedCompileTimeConstant<T>($this$wrap, this.constantExpressionEvaluator.getModule$frontend(), parameters);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsigned, boolean isUnsignedLong, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal) {
        return this.wrap($this$wrap, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, isUnsigned, isUnsignedLong, usesVariableAsConstant, usesNonConstValAsConstant, isConvertableConstVal));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl8 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = false;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            bl7 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    private static final Unit evaluateUnaryAndCheck$lambda$0(ConstantExpressionEvaluatorVisitor this$0, KtExpression $callExpression) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callExpression, (String)"$callExpression");
        BindingTrace bindingTrace = this$0.trace;
        PsiElement $this$getStrictParentOfType$iv = $callExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtExpression ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true);
        if (ktExpression == null) {
            ktExpression = $callExpression;
        }
        bindingTrace.report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)ktExpression)));
        return Unit.INSTANCE;
    }

    private static final Unit evaluateBinaryAndCheck$lambda$1(ConstantExpressionEvaluatorVisitor this$0, KtExpression $callExpression) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$callExpression, (String)"$callExpression");
        BindingTrace bindingTrace = this$0.trace;
        PsiElement $this$getStrictParentOfType$iv = $callExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtExpression ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true);
        if (ktExpression == null) {
            ktExpression = $callExpression;
        }
        bindingTrace.report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)ktExpression)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue $receiver, CompileTimeConstant.Parameters parameters) {
        return $this.wrap($receiver, parameters);
    }

    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.builtIns;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "ctcType", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "getValue", "()Ljava/lang/Object;", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "frontend"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType ctcType;
        @NotNull
        private final KtExpression expression;

        public OperationArgument(@NotNull Object value2, @NotNull CompileTimeType ctcType, @NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)ctcType), (String)"ctcType");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            this.value = value2;
            this.ctcType = ctcType;
            this.expression = expression2;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }
    }
}

