/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClass;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.overrides.IrJavaIncompatibilityRulesOverridabilityCondition;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.InjectedValue;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrMemberWithContainerSource;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010(\u001a\u00020\u00162\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u001a\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0016J\u001a\u00109\u001a\u0004\u0018\u00010\u00162\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010>\u001a\u00020\f2\u0006\u0010?\u001a\u00020\u00162\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010@\u001a\u00020\f2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0016J\u0018\u0010E\u001a\u00020\f2\u0006\u0010:\u001a\u00020F2\u0006\u0010C\u001a\u00020DH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u00107\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\u000e\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "irDeserializer", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "parametersAreAssignable", "", "getParametersAreAssignable", "()Z", "externalOverridabilityConditions", "", "Lorg/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "kotlinIrInternalPackage", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "specialAnnotationConstructors", "", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "rawTypeAnnotationClass", "rawTypeAnnotationConstructor", "getRawTypeAnnotationConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "createSpecialAnnotationClass", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "registerDeclarations", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "findInjectedValue", "Lorg/jetbrains/kotlin/fir/backend/InjectedValue;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "irNeedsDeserialization", "getIrNeedsDeserialization", "generateOrGetFacadeClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "deserializeToplevelClass", "irClass", "hasBackingField", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isTrueStatic", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1863#2,2:114\n*S KotlinDebug\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n*L\n74#1:114,2\n*E\n"})
public final class JvmFir2IrExtensions
implements JvmGeneratorExtensions,
Fir2IrExtensions {
    @NotNull
    private final JvmIrDeserializer irDeserializer;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final List<IrConstructor> specialAnnotationConstructors;
    @NotNull
    private final IrClass rawTypeAnnotationClass;
    @NotNull
    private final IrConstructor rawTypeAnnotationConstructor;
    private final boolean irNeedsDeserialization;

    public JvmFir2IrExtensions(@NotNull CompilerConfiguration configuration2, @NotNull JvmIrDeserializer irDeserializer, @NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)irDeserializer, (String)"irDeserializer");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.irDeserializer = irDeserializer;
        this.mangler = mangler;
        this.classNameOverride = new LinkedHashMap();
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2));
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName);
        this.specialAnnotationConstructors = new ArrayList();
        this.rawTypeAnnotationClass = this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.rawTypeAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.rawTypeAnnotationClass));
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        this.createSpecialAnnotationClass(fqName2, this.kotlinJvmInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_MUTABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.irNeedsDeserialization = configuration2.get(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.NONE) != JvmSerializeIrMode.NONE;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
        return CollectionsKt.listOf((Object)new IrJavaIncompatibilityRulesOverridabilityCondition());
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public IrConstructor getRawTypeAnnotationConstructor() {
        return this.rawTypeAnnotationConstructor;
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrClass irClass;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u240 = irClass = IrUtilsKt.createSpecialAnnotationClass(IrFactoryImpl.INSTANCE, fqn, parent2);
        boolean bl = false;
        this.specialAnnotationConstructors.add((IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors($this$createSpecialAnnotationClass_u24lambda_u240)));
        return irClass;
    }

    @Override
    public void registerDeclarations(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        PublicIdSignatureComputer signatureComputer = new PublicIdSignatureComputer(this.mangler);
        Iterable $this$forEach$iv = this.specialAnnotationConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructor constructor2 = (IrConstructor)element$iv;
            boolean bl = false;
            symbolTable.declareConstructorWithSignature(signatureComputer.composePublicIdSignature(constructor2, false), constructor2.getSymbol());
        }
    }

    @Override
    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)calleeReference, (String)"calleeReference");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        return null;
    }

    @Override
    public boolean getIrNeedsDeserialization() {
        return this.irNeedsDeserialization;
    }

    @Override
    @Nullable
    public IrClass generateOrGetFacadeClass(@NotNull IrMemberWithContainerSource declaration, @NotNull Fir2IrComponents components) {
        JvmFileFacadeClass jvmFileFacadeClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        DeserializedContainerSource deserializedContainerSource = declaration.getContainerSource();
        if (deserializedContainerSource == null) {
            return null;
        }
        DeserializedContainerSource deserializedSource = deserializedContainerSource;
        if (!(deserializedSource instanceof FacadeClassSource)) {
            return null;
        }
        JvmClassName jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        IrDeclarationOrigin irDeclarationOrigin = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName() != null ? IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS() : IrDeclarationOrigin.Companion.getFILE_CLASS();
        Name name2 = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        JvmFileFacadeClass it = jvmFileFacadeClass = new JvmFileFacadeClass(irDeclarationOrigin, name2, deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)arg_0 -> JvmFir2IrExtensions.generateOrGetFacadeClass$lambda$2(this, components, arg_0)));
        boolean bl = false;
        IrUtilsKt.createParameterDeclarations(it);
        this.getClassNameOverride().put(it, facadeName);
        return jvmFileFacadeClass;
    }

    @Override
    public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        return this.irDeserializer.deserializeTopLevelClass(irClass, components.getIrBuiltIns(), components.getSymbolTable(), components.getIrProviders(), this);
    }

    @Override
    public boolean hasBackingField(@NotNull FirProperty property, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return property.getOrigin() instanceof FirDeclarationOrigin.Java || Fir2IrExtensions.Default.INSTANCE.hasBackingField(property, session2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTrueStatic(@NotNull FirCallableDeclaration declaration, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (FirAnnotationUtilsKt.hasAnnotation(declaration, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_CLASS_ID(), session2)) return true;
        if (!(declaration instanceof FirPropertyAccessor)) return false;
        FirPropertyAccessor firPropertyAccessor = (FirPropertyAccessor)declaration;
        Object object = firPropertyAccessor;
        if (firPropertyAccessor == null) return false;
        FirPropertySymbol firPropertySymbol = ((FirPropertyAccessor)object).getPropertySymbol();
        object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        FirProperty firProperty = (FirProperty)((FirBasedSymbol)object).getFir();
        object = firProperty;
        if (firProperty == null) return false;
        if (!FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)object, AnnotationUtilKt.getJVM_STATIC_ANNOTATION_CLASS_ID(), session2)) return false;
        return true;
    }

    private static final boolean generateOrGetFacadeClass$lambda$2(JvmFir2IrExtensions this$0, Fir2IrComponents $components, IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$components, (String)"$components");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this$0.deserializeToplevelClass(irClass, $components);
    }
}

