/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.syntax;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.ElementTypeUtils;
import org.jetbrains.kotlin.KtLightSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtPsiSourceElement;
import org.jetbrains.kotlin.KtRealPsiSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirExpressionSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J6\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirConfusingWhenBranchSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirExpressionSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lcom/intellij/psi/PsiElement;", "()V", "prohibitedTokens", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "checkCondition", "", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkConditionExpression", "offset", "", "expression", "Lcom/intellij/lang/LighterASTNode;", "tree", "Lcom/intellij/util/diff/FlyweightCapableTreeStructure;", "rawExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkLightTree", "element", "source", "Lorg/jetbrains/kotlin/KtLightSourceElement;", "checkPsi", "Lorg/jetbrains/kotlin/KtPsiSourceElement;", "psi", "checkers"})
public final class FirConfusingWhenBranchSyntaxChecker
extends FirExpressionSyntaxChecker<FirWhenExpression, PsiElement> {
    @NotNull
    public static final FirConfusingWhenBranchSyntaxChecker INSTANCE = new FirConfusingWhenBranchSyntaxChecker();
    @NotNull
    private static final TokenSet prohibitedTokens;

    private FirConfusingWhenBranchSyntaxChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void checkLightTree(@NotNull FirWhenExpression element, @NotNull KtLightSourceElement source2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (element.getSubject() == null && element.getSubjectVariable() == null) {
            return;
        }
        FlyweightCapableTreeStructure<LighterASTNode> tree = source2.getTreeStructure();
        Iterable $this$filter$iv = SourceHelpersKt.getChildren(source2.getLighterASTNode(), tree);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LighterASTNode it = (LighterASTNode)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.WHEN_ENTRY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List entries = (List)destination$iv$iv;
        int offset2 = source2.getStartOffset() - source2.getLighterASTNode().getStartOffset();
        for (LighterASTNode entry : entries) {
            for (LighterASTNode node : SourceHelpersKt.getChildren(entry, tree)) {
                LighterASTNode lighterASTNode2;
                LighterASTNode it;
                boolean $i$f$firstOrNull;
                Iterable $this$firstOrNull$iv;
                IElementType iElementType = node.getTokenType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_EXPRESSION)) {
                    Object v0;
                    block10: {
                        $this$firstOrNull$iv = SourceHelpersKt.getChildren(node, tree);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LighterASTNode)element$iv;
                            boolean bl = false;
                            if (!ElementTypeUtils.INSTANCE.isExpression(it)) continue;
                            v0 = element$iv;
                            break block10;
                        }
                        v0 = null;
                    }
                    lighterASTNode2 = v0;
                } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.WHEN_CONDITION_IN_RANGE)) {
                    Object v2;
                    block11: {
                        $this$firstOrNull$iv = SourceHelpersKt.getChildren(node, tree);
                        $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            it = (LighterASTNode)element$iv;
                            boolean bl = false;
                            if (!(!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE) && ElementTypeUtils.INSTANCE.isExpression(it))) continue;
                            v2 = element$iv;
                            break block11;
                        }
                        v2 = null;
                    }
                    lighterASTNode2 = v2;
                } else {
                    lighterASTNode2 = null;
                }
                if (lighterASTNode2 == null) continue;
                LighterASTNode expression2 = lighterASTNode2;
                this.checkConditionExpression(offset2, expression2, tree, context, reporter);
            }
        }
    }

    private final void checkConditionExpression(int offset2, LighterASTNode expression2, FlyweightCapableTreeStructure<LighterASTNode> tree, CheckerContext context, DiagnosticReporter reporter) {
        boolean shouldReport;
        boolean bl;
        IElementType iElementType = expression2.getTokenType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.IS_EXPRESSION)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BINARY_EXPRESSION)) {
            Object element$iv2;
            block6: {
                Iterable $this$first$iv = SourceHelpersKt.getChildren(expression2, tree);
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    LighterASTNode it = (LighterASTNode)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.OPERATION_REFERENCE)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String operationTokenName = element$iv2.toString();
            IElementType operationToken = ElementTypeUtils.INSTANCE.getOperationSymbol(operationTokenName);
            bl = prohibitedTokens.contains(operationToken);
        } else {
            bl = shouldReport = false;
        }
        if (shouldReport) {
            KtLightSourceElement source2 = new KtLightSourceElement(expression2, offset2 + expression2.getStartOffset(), offset2 + expression2.getEndOffset(), tree, null, 16, null);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getCONFUSING_BRANCH_CONDITION(), (DiagnosticContext)context, null, 8, null);
        }
    }

    @Override
    public void checkPsi(@NotNull FirWhenExpression element, @NotNull KtPsiSourceElement source2, @NotNull PsiElement psi, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (element.getSubject() == null && element.getSubjectVariable() == null) {
            return;
        }
        KtWhenExpression whenExpression = (KtWhenExpression)psi;
        if (whenExpression.getSubjectExpression() == null && whenExpression.getSubjectVariable() == null) {
            return;
        }
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            KtWhenCondition[] ktWhenConditionArray;
            Intrinsics.checkNotNullExpressionValue((Object)entry.getConditions(), (String)"entry.conditions");
            for (KtWhenCondition condition : ktWhenConditionArray) {
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"condition");
                this.checkCondition(condition, context, reporter);
            }
        }
    }

    private final void checkCondition(KtWhenCondition condition, CheckerContext context, DiagnosticReporter reporter) {
        KtWhenCondition ktWhenCondition = condition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            this.checkConditionExpression(((KtWhenConditionWithExpression)condition).getExpression(), context, reporter);
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            this.checkConditionExpression(((KtWhenConditionInRange)condition).getRangeExpression(), context, reporter);
        }
    }

    private final void checkConditionExpression(KtExpression rawExpression, CheckerContext context, DiagnosticReporter reporter) {
        boolean shouldReport;
        if (rawExpression == null) {
            return;
        }
        if (rawExpression instanceof KtParenthesizedExpression) {
            return;
        }
        KtExpression ktExpression = KtPsiUtil.safeDeparenthesize(rawExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"safeDeparenthesize(rawExpression)");
        KtExpression expression2 = ktExpression;
        boolean bl = expression2 instanceof KtIsExpression ? true : (shouldReport = expression2 instanceof KtBinaryExpression ? prohibitedTokens.contains(((KtBinaryExpression)expression2).getOperationToken()) : false);
        if (shouldReport) {
            KtRealPsiSourceElement source2 = new KtRealPsiSourceElement(rawExpression);
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getCONFUSING_BRANCH_CONDITION(), (DiagnosticContext)context, null, 8, null);
        }
    }

    static {
        IElementType[] iElementTypeArray = new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ, KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ANDAND, KtTokens.OROR};
        TokenSet tokenSet = TokenSet.create(iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(\n        IN_KEYWO\u2026       ANDAND, OROR\n    )");
        prohibitedTokens = tokenSet;
    }
}

