// CHECKSTYLE:OFF

package hudson.matrix;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code MatrixProject.InvalidAxisValue}: {@code Matrix axis value
     * ''{0}'' is invalid: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Matrix axis value ''{0}'' is invalid: {1}}
     */
    public static String MatrixProject_InvalidAxisValue(Object arg0, Object arg1) {
        return holder.format("MatrixProject.InvalidAxisValue", arg0, arg1);
    }

    /**
     * Key {@code MatrixProject.InvalidAxisValue}: {@code Matrix axis value
     * ''{0}'' is invalid: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Matrix axis value ''{0}'' is invalid: {1}}
     */
    public static Localizable _MatrixProject_InvalidAxisValue(Object arg0, Object arg1) {
        return new Localizable(holder, "MatrixProject.InvalidAxisValue", arg0, arg1);
    }

    /**
     * Key {@code MatrixBuild.Completed}: {@code {0} completed with result
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} completed with result {1}}
     */
    public static String MatrixBuild_Completed(Object arg0, Object arg1) {
        return holder.format("MatrixBuild.Completed", arg0, arg1);
    }

    /**
     * Key {@code MatrixBuild.Completed}: {@code {0} completed with result
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} completed with result {1}}
     */
    public static Localizable _MatrixBuild_Completed(Object arg0, Object arg1) {
        return new Localizable(holder, "MatrixBuild.Completed", arg0, arg1);
    }

    /**
     * Key {@code MatrixBuild.Cancelled}: {@code Cancelled {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cancelled {0}}
     */
    public static String MatrixBuild_Cancelled(Object arg0) {
        return holder.format("MatrixBuild.Cancelled", arg0);
    }

    /**
     * Key {@code MatrixBuild.Cancelled}: {@code Cancelled {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cancelled {0}}
     */
    public static Localizable _MatrixBuild_Cancelled(Object arg0) {
        return new Localizable(holder, "MatrixBuild.Cancelled", arg0);
    }

    /**
     * Key {@code MatrixProject.DuplicateAxisName}: {@code Duplicate axis
     * name}.
     * 
     * @return
     *     {@code Duplicate axis name}
     */
    public static String MatrixProject_DuplicateAxisName() {
        return holder.format("MatrixProject.DuplicateAxisName");
    }

    /**
     * Key {@code MatrixProject.DuplicateAxisName}: {@code Duplicate axis
     * name}.
     * 
     * @return
     *     {@code Duplicate axis name}
     */
    public static Localizable _MatrixProject_DuplicateAxisName() {
        return new Localizable(holder, "MatrixProject.DuplicateAxisName");
    }

    /**
     * Key {@code MatrixBuild.Triggering}: {@code Triggering {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggering {0}}
     */
    public static String MatrixBuild_Triggering(Object arg0) {
        return holder.format("MatrixBuild.Triggering", arg0);
    }

    /**
     * Key {@code MatrixBuild.Triggering}: {@code Triggering {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Triggering {0}}
     */
    public static Localizable _MatrixBuild_Triggering(Object arg0) {
        return new Localizable(holder, "MatrixBuild.Triggering", arg0);
    }

    /**
     * Key {@code AxisDescriptor.EmptyAxisName}: {@code Axis name can not be
     * empty}.
     * 
     * @return
     *     {@code Axis name can not be empty}
     */
    public static String AxisDescriptor_EmptyAxisName() {
        return holder.format("AxisDescriptor.EmptyAxisName");
    }

    /**
     * Key {@code AxisDescriptor.EmptyAxisName}: {@code Axis name can not be
     * empty}.
     * 
     * @return
     *     {@code Axis name can not be empty}
     */
    public static Localizable _AxisDescriptor_EmptyAxisName() {
        return new Localizable(holder, "AxisDescriptor.EmptyAxisName");
    }

    /**
     * Key {@code MatrixProject.Pronoun}: {@code Multi-configuration
     * project}.
     * 
     * @return
     *     {@code Multi-configuration project}
     */
    public static String MatrixProject_Pronoun() {
        return holder.format("MatrixProject.Pronoun");
    }

    /**
     * Key {@code MatrixProject.Pronoun}: {@code Multi-configuration
     * project}.
     * 
     * @return
     *     {@code Multi-configuration project}
     */
    public static Localizable _MatrixProject_Pronoun() {
        return new Localizable(holder, "MatrixProject.Pronoun");
    }

    /**
     * Key {@code MatrixProject.DisplayName}: {@code Multi-configuration
     * project}.
     * 
     * @return
     *     {@code Multi-configuration project}
     */
    public static String MatrixProject_DisplayName() {
        return holder.format("MatrixProject.DisplayName");
    }

    /**
     * Key {@code MatrixProject.DisplayName}: {@code Multi-configuration
     * project}.
     * 
     * @return
     *     {@code Multi-configuration project}
     */
    public static Localizable _MatrixProject_DisplayName() {
        return new Localizable(holder, "MatrixProject.DisplayName");
    }

    /**
     * Key {@code MatrixBuild.Interrupting}: {@code Interrupting {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Interrupting {0}}
     */
    public static String MatrixBuild_Interrupting(Object arg0) {
        return holder.format("MatrixBuild.Interrupting", arg0);
    }

    /**
     * Key {@code MatrixBuild.Interrupting}: {@code Interrupting {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Interrupting {0}}
     */
    public static Localizable _MatrixBuild_Interrupting(Object arg0) {
        return new Localizable(holder, "MatrixBuild.Interrupting", arg0);
    }

    /**
     * Key {@code LabelAxis.DisplayName}: {@code Slaves}.
     * 
     * @return
     *     {@code Slaves}
     */
    public static String LabelAxis_DisplayName() {
        return holder.format("LabelAxis.DisplayName");
    }

    /**
     * Key {@code LabelAxis.DisplayName}: {@code Slaves}.
     * 
     * @return
     *     {@code Slaves}
     */
    public static Localizable _LabelAxis_DisplayName() {
        return new Localizable(holder, "LabelAxis.DisplayName");
    }

    /**
     * Key {@code MatrixProject.Description}: {@code Suitable for projects
     * that need a large number of different configurations, such as testing
     * on multiple environments, platform-specific builds, etc.}.
     * 
     * @return
     *     {@code Suitable for projects that need a large number of different
     *     configurations, such as testing on multiple environments,
     *     platform-specific builds, etc.}
     */
    public static String MatrixProject_Description() {
        return holder.format("MatrixProject.Description");
    }

    /**
     * Key {@code MatrixProject.Description}: {@code Suitable for projects
     * that need a large number of different configurations, such as testing
     * on multiple environments, platform-specific builds, etc.}.
     * 
     * @return
     *     {@code Suitable for projects that need a large number of different
     *     configurations, such as testing on multiple environments,
     *     platform-specific builds, etc.}
     */
    public static Localizable _MatrixProject_Description() {
        return new Localizable(holder, "MatrixProject.Description");
    }

    /**
     * Key {@code TextArea.DisplayName}: {@code User-defined Axis}.
     * 
     * @return
     *     {@code User-defined Axis}
     */
    public static String TextArea_DisplayName() {
        return holder.format("TextArea.DisplayName");
    }

    /**
     * Key {@code TextArea.DisplayName}: {@code User-defined Axis}.
     * 
     * @return
     *     {@code User-defined Axis}
     */
    public static Localizable _TextArea_DisplayName() {
        return new Localizable(holder, "TextArea.DisplayName");
    }

    /**
     * Key {@code LabelExpAxis.DisplayName}: {@code Label expression}.
     * 
     * @return
     *     {@code Label expression}
     */
    public static String LabelExpAxis_DisplayName() {
        return holder.format("LabelExpAxis.DisplayName");
    }

    /**
     * Key {@code LabelExpAxis.DisplayName}: {@code Label expression}.
     * 
     * @return
     *     {@code Label expression}
     */
    public static Localizable _LabelExpAxis_DisplayName() {
        return new Localizable(holder, "LabelExpAxis.DisplayName");
    }

    /**
     * Key {@code MatrixConfiguration.DisableNotAllowed}: {@code Matrix
     * configurations cannot be disabled separately. Disable the parent
     * project instead}.
     * 
     * @return
     *     {@code Matrix configurations cannot be disabled separately. Disable
     *     the parent project instead}
     */
    public static String MatrixConfiguration_DisableNotAllowed() {
        return holder.format("MatrixConfiguration.DisableNotAllowed");
    }

    /**
     * Key {@code MatrixConfiguration.DisableNotAllowed}: {@code Matrix
     * configurations cannot be disabled separately. Disable the parent
     * project instead}.
     * 
     * @return
     *     {@code Matrix configurations cannot be disabled separately. Disable
     *     the parent project instead}
     */
    public static Localizable _MatrixConfiguration_DisableNotAllowed() {
        return new Localizable(holder, "MatrixConfiguration.DisableNotAllowed");
    }

    /**
     * Key {@code JDKAxis.DisplayName}: {@code JDK}.
     * 
     * @return
     *     {@code JDK}
     */
    public static String JDKAxis_DisplayName() {
        return holder.format("JDKAxis.DisplayName");
    }

    /**
     * Key {@code JDKAxis.DisplayName}: {@code JDK}.
     * 
     * @return
     *     {@code JDK}
     */
    public static Localizable _JDKAxis_DisplayName() {
        return new Localizable(holder, "JDKAxis.DisplayName");
    }

    /**
     * Key {@code MatrixBuild.AppearsCancelled}: {@code {0} appears to be
     * cancelled}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} appears to be cancelled}
     */
    public static String MatrixBuild_AppearsCancelled(Object arg0) {
        return holder.format("MatrixBuild.AppearsCancelled", arg0);
    }

    /**
     * Key {@code MatrixBuild.AppearsCancelled}: {@code {0} appears to be
     * cancelled}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} appears to be cancelled}
     */
    public static Localizable _MatrixBuild_AppearsCancelled(Object arg0) {
        return new Localizable(holder, "MatrixBuild.AppearsCancelled", arg0);
    }

    /**
     * Key {@code MatrixProject.InvalidAxisName}: {@code Matrix axis name
     * ''{0}'' is invalid: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Matrix axis name ''{0}'' is invalid: {1}}
     */
    public static String MatrixProject_InvalidAxisName(Object arg0, Object arg1) {
        return holder.format("MatrixProject.InvalidAxisName", arg0, arg1);
    }

    /**
     * Key {@code MatrixProject.InvalidAxisName}: {@code Matrix axis name
     * ''{0}'' is invalid: {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Matrix axis name ''{0}'' is invalid: {1}}
     */
    public static Localizable _MatrixProject_InvalidAxisName(Object arg0, Object arg1) {
        return new Localizable(holder, "MatrixProject.InvalidAxisName", arg0, arg1);
    }

    /**
     * Key {@code MatrixBuild.depends_on_this}: {@code {0} depends on this.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} depends on this.}
     */
    public static String MatrixBuild_depends_on_this(Object arg0) {
        return holder.format("MatrixBuild.depends_on_this", arg0);
    }

    /**
     * Key {@code MatrixBuild.depends_on_this}: {@code {0} depends on this.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} depends on this.}
     */
    public static Localizable _MatrixBuild_depends_on_this(Object arg0) {
        return new Localizable(holder, "MatrixBuild.depends_on_this", arg0);
    }

    /**
     * Key {@code MatrixConfiguration.Pronoun}: {@code Configuration}.
     * 
     * @return
     *     {@code Configuration}
     */
    public static String MatrixConfiguration_Pronoun() {
        return holder.format("MatrixConfiguration.Pronoun");
    }

    /**
     * Key {@code MatrixConfiguration.Pronoun}: {@code Configuration}.
     * 
     * @return
     *     {@code Configuration}
     */
    public static Localizable _MatrixConfiguration_Pronoun() {
        return new Localizable(holder, "MatrixConfiguration.Pronoun");
    }

}
