/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.matrixauth.inheritance;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.security.Permission;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategy;
import org.jenkinsci.plugins.matrixauth.inheritance.InheritanceStrategyDescriptor;
import org.jenkinsci.plugins.matrixauth.inheritance.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.springframework.security.core.Authentication;

public class InheritParentStrategy
extends InheritanceStrategy {
    @DataBoundConstructor
    public InheritParentStrategy() {
    }

    @Override
    protected boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission, ACL child, @CheckForNull ACL parent, ACL root) {
        if (a.equals(ACL.SYSTEM2)) {
            return true;
        }
        if (InheritParentStrategy.isParentReadPermissionRequired() && parent != null && (Item.READ.equals((Object)permission) || Item.DISCOVER.equals((Object)permission))) {
            return parent.hasPermission2(a, permission);
        }
        if (parent == null) {
            return root.hasPermission2(a, permission) || child.hasPermission2(a, permission);
        }
        return parent.hasPermission2(a, permission) || child.hasPermission2(a, permission);
    }

    @Symbol(value={"inheriting"})
    @Extension(ordinal=100.0)
    public static class DescriptorImpl
    extends InheritanceStrategyDescriptor {
        @Override
        public boolean isApplicable(Class<?> clazz) {
            return AbstractItem.class.isAssignableFrom(clazz);
        }

        @NonNull
        public String getDisplayName() {
            return Messages.InheritParentStrategy_DisplayName();
        }
    }
}

