/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mailer.tasks;

import hudson.DescriptorExtensionList;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Describable;
import hudson.model.Hudson;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;
import jenkins.plugins.mailer.tasks.MailAddressFilterDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MailAddressFilter
implements Describable<MailAddressFilter>,
ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(MailAddressFilter.class.getName());

    public abstract boolean isFiltered(AbstractBuild<?, ?> var1, BuildListener var2, InternetAddress var3);

    public static Set<InternetAddress> getFilteredRecipients(AbstractBuild<?, ?> build, BuildListener listener, Set<InternetAddress> recipients) {
        LinkedHashSet<InternetAddress> rcp = new LinkedHashSet<InternetAddress>();
        for (InternetAddress address : recipients) {
            if (MailAddressFilter.isFilteredRecipient(address, listener, build)) continue;
            rcp.add(address);
        }
        return rcp;
    }

    private static boolean isFilteredRecipient(InternetAddress address, BuildListener listener, AbstractBuild<?, ?> build) {
        LOGGER.log(Level.FINE, "Checking for filtered email address for \"{0}\"", address);
        for (MailAddressFilter filter : MailAddressFilter.allExtensions()) {
            LOGGER.log(Level.FINE, "Checking for filtered email address for \"{0}\" with \"{1}\"", new Object[]{address, filter.getClass().getName()});
            if (!filter.isFiltered(build, listener, address)) continue;
            LOGGER.log(Level.FINE, "Filtered out email recipient \"{0}\"", address);
            return true;
        }
        return false;
    }

    public MailAddressFilterDescriptor getDescriptor() {
        return (MailAddressFilterDescriptor)Hudson.getInstance().getDescriptor(this.getClass());
    }

    public static DescriptorExtensionList<MailAddressFilter, MailAddressFilterDescriptor> all() {
        return Hudson.getInstance().getDescriptorList(MailAddressFilter.class);
    }

    public static ExtensionList<MailAddressFilter> allExtensions() {
        return Hudson.getInstance().getExtensionList(MailAddressFilter.class);
    }
}

