/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.tasks.javadoc.Messages;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocArchiver
extends Recorder {
    private final String javadocDir;
    private final boolean keepAll;

    @DataBoundConstructor
    public JavadocArchiver(String javadocDir, boolean keepAll) {
        this.javadocDir = javadocDir;
        this.keepAll = keepAll;
    }

    public String getJavadocDir() {
        return this.javadocDir;
    }

    public boolean isKeepAll() {
        return this.keepAll;
    }

    private static File getJavadocDir(AbstractItem project) {
        return new File(project.getRootDir(), "javadoc");
    }

    private static File getJavadocDir(Run run) {
        return new File(run.getRootDir(), "javadoc");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        listener.getLogger().println(Messages.JavadocArchiver_Publishing());
        EnvVars env = build.getEnvironment((TaskListener)listener);
        FilePath javadoc = build.getWorkspace().child(env.expand(this.javadocDir));
        FilePath target = new FilePath(this.keepAll ? JavadocArchiver.getJavadocDir(build) : JavadocArchiver.getJavadocDir((AbstractItem)build.getProject()));
        try {
            if (javadoc.copyRecursiveTo("**/*", target) == 0) {
                if (build.getResult().isBetterOrEqualTo(Result.UNSTABLE)) {
                    listener.error(Messages.JavadocArchiver_NoMatchFound(javadoc, javadoc.validateAntFileMask("**/*")));
                }
                build.setResult(Result.FAILURE);
                return true;
            }
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            e.printStackTrace(listener.fatalError(Messages.JavadocArchiver_UnableToCopy(javadoc, target)));
            build.setResult(Result.FAILURE);
            return true;
        }
        if (this.keepAll) {
            build.addAction((Action)new JavadocBuildAction(build));
        }
        return true;
    }

    public Collection<Action> getProjectActions(AbstractProject project) {
        return Collections.singleton(new JavadocAction((AbstractItem)project));
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return Messages.JavadocArchiver_DisplayName();
        }

        public FormValidation doCheckJavadocDir(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException, ServletException {
            FilePath ws = project.getSomeWorkspace();
            return ws != null ? ws.validateRelativeDirectory(value) : FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavadocBuildAction
    extends BaseJavadocAction {
        private final AbstractBuild<?, ?> build;

        public JavadocBuildAction(AbstractBuild<?, ?> build) {
            this.build = build;
        }

        @Override
        protected String getTitle() {
            return this.build.getDisplayName() + " javadoc";
        }

        @Override
        protected File dir() {
            return JavadocArchiver.getJavadocDir(this.build);
        }
    }

    public static class JavadocAction
    extends BaseJavadocAction
    implements ProminentProjectAction {
        private final AbstractItem project;

        public JavadocAction(AbstractItem project) {
            this.project = project;
        }

        protected File dir() {
            File javadocDir;
            AbstractProject abstractProject;
            Run run;
            if (this.project instanceof AbstractProject && (run = (abstractProject = (AbstractProject)this.project).getLastSuccessfulBuild()) != null && (javadocDir = JavadocArchiver.getJavadocDir(run)).exists()) {
                return javadocDir;
            }
            return JavadocArchiver.getJavadocDir(this.project);
        }

        protected String getTitle() {
            return this.project.getDisplayName() + " javadoc";
        }
    }

    protected static abstract class BaseJavadocAction
    implements Action {
        protected BaseJavadocAction() {
        }

        public String getUrlName() {
            return "javadoc";
        }

        public String getDisplayName() {
            File dir = this.dir();
            if (dir != null && new File(dir, "help-doc.html").exists()) {
                return Messages.JavadocArchiver_DisplayName_Javadoc();
            }
            return Messages.JavadocArchiver_DisplayName_Generic();
        }

        public String getIconFileName() {
            File dir = this.dir();
            if (dir != null && dir.exists()) {
                return "help.png";
            }
            return null;
        }

        public void doDynamic(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new DirectoryBrowserSupport((ModelObject)this, new FilePath(this.dir()), this.getTitle(), "help.png", false).generateResponse(req, rsp, (Object)this);
        }

        protected abstract String getTitle();

        protected abstract File dir();
    }
}

