/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.git.Revision;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.promoted_builds.Promotion;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitRevisionBuildParameters
extends AbstractBuildParameters {
    private boolean combineQueuedCommits = false;

    @DataBoundConstructor
    public GitRevisionBuildParameters(boolean combineQueuedCommits) {
        this.combineQueuedCommits = combineQueuedCommits;
    }

    public GitRevisionBuildParameters() {
    }

    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) {
        AbstractBuild targetBuild;
        BuildData data = (BuildData)build.getAction(BuildData.class);
        if (data == null && Jenkins.get().getPlugin("promoted-builds") != null && build instanceof Promotion && (targetBuild = ((Promotion)build).getTargetBuild()) != null) {
            data = (BuildData)targetBuild.getAction(BuildData.class);
        }
        if (data == null) {
            listener.getLogger().println("This project doesn't use Git as SCM. Can't pass the revision to downstream");
            return null;
        }
        Revision lastBuiltRevision = data.getLastBuiltRevision();
        if (lastBuiltRevision == null) {
            listener.getLogger().println("Missing build information. Can't pass the revision to downstream");
            return null;
        }
        return new RevisionParameterAction(lastBuiltRevision, this.getCombineQueuedCommits());
    }

    public boolean getCombineQueuedCommits() {
        return this.combineQueuedCommits;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Pass-through Git Commit that was built";
        }
    }
}

