/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.Extension;
import hudson.model.Item;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.ArrayList;
import java.util.List;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitBranchSpecifierColumn
extends ListViewColumn {
    @DataBoundConstructor
    public GitBranchSpecifierColumn() {
    }

    public List<String> getBranchSpecifier(Item item) {
        ArrayList<String> branchSpec = new ArrayList<String>();
        SCMTriggerItem s = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item);
        if (s != null) {
            for (SCM scm : s.getSCMs()) {
                if (!(scm instanceof GitSCM)) continue;
                GitSCM gitScm = (GitSCM)scm;
                for (BranchSpec spec : gitScm.getBranches()) {
                    branchSpec.add(spec.getName());
                }
            }
        }
        return branchSpec;
    }

    public String breakOutString(List<String> branches) {
        return StringUtils.join(branches, (String)", ");
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Git Branches";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

