/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.plugins.recipients;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.emailext.ExtendedEmailPublisherContext;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.RecipientProvider;
import hudson.plugins.emailext.plugins.RecipientProviderDescriptor;
import hudson.plugins.emailext.plugins.recipients.RecipientProviderUtilities;
import hudson.scm.ChangeLogSet;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import jenkins.model.Jenkins;
import jenkins.scm.RunWithSCM;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class UpstreamComitterRecipientProvider
extends RecipientProvider {
    @DataBoundConstructor
    public UpstreamComitterRecipientProvider() {
    }

    @Override
    public void addRecipients(final ExtendedEmailPublisherContext context, EnvVars env, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc) {
        final class Debug
        implements RecipientProviderUtilities.IDebug {
            private final ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
            private final PrintStream logger = context.getListener().getLogger();

            Debug() {
            }

            @Override
            public void send(String format, Object ... args) {
                this.descriptor.debug(this.logger, format, args);
            }
        }
        Debug debug = new Debug();
        debug.send("Sending email to upstream committer(s).", new Object[0]);
        Cause.UpstreamCause upc = (Cause.UpstreamCause)context.getRun().getCause(Cause.UpstreamCause.class);
        while (upc != null) {
            Job p = (Job)Jenkins.get().getItemByFullName(upc.getUpstreamProject());
            if (p == null) {
                context.getListener().getLogger().print("There is a break in the project linkage, could not retrieve upstream project information");
                break;
            }
            Run cur = p.getBuildByNumber(upc.getUpstreamBuild());
            upc = (Cause.UpstreamCause)cur.getCause(Cause.UpstreamCause.class);
            this.addUpstreamCommittersTriggeringBuild(cur, to, cc, bcc, env, context, debug);
        }
    }

    private void addUpstreamCommittersTriggeringBuild(Run<?, ?> run, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, ExtendedEmailPublisherContext context, RecipientProviderUtilities.IDebug debug) {
        debug.send("Adding upstream committer from job %s with build number %s", run.getParent().getDisplayName(), run.getNumber());
        if (run instanceof RunWithSCM) {
            List changeSets = ((RunWithSCM)run).getChangeSets();
            for (ChangeLogSet changeSet : changeSets) {
                for (ChangeLogSet.Entry change : changeSet) {
                    this.addUserFromChangeSet(change, to, cc, bcc, env, context, debug);
                }
            }
        }
    }

    private void addUserFromChangeSet(ChangeLogSet.Entry change, Set<InternetAddress> to, Set<InternetAddress> cc, Set<InternetAddress> bcc, EnvVars env, ExtendedEmailPublisherContext context, RecipientProviderUtilities.IDebug debug) {
        User user = change.getAuthor();
        RecipientProviderUtilities.addUsers(Collections.singleton(user), context, env, to, cc, bcc, debug);
    }

    @Extension
    @Symbol(value={"upstreamDevelopers"})
    public static final class DescriptorImpl
    extends RecipientProviderDescriptor {
        public String getDisplayName() {
            return Messages.UpstreamComitterRecipientProvider_DisplayName();
        }
    }
}

