/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity;

import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Util;
import hudson.model.PageDecorator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.CryptoConfidentialKey;
import org.jenkinsci.main.modules.instance_identity.PageDecoratorImpl;
import org.jenkinsci.main.modules.instance_identity.SelfSignedCertificate;
import org.jenkinsci.main.modules.instance_identity.pem.PEMHelper;

public class InstanceIdentity {
    private final KeyPair keys;
    private X509Certificate certificate;
    private final CryptoConfidentialKey KEY = new CryptoConfidentialKey(InstanceIdentity.class, "KEY");
    private static final Logger LOGGER = Logger.getLogger(InstanceIdentity.class.getName());

    public InstanceIdentity() throws IOException {
        this(new File(Jenkins.getActiveInstance().getRootDir(), "identity.key.enc"), new File(Jenkins.getActiveInstance().getRootDir(), "identity.key"));
    }

    public InstanceIdentity(File keyFile) throws IOException {
        this(keyFile, null);
    }

    InstanceIdentity(File keyFile, File oldKeyFile) throws IOException {
        KeyPairGenerator gen;
        try {
            gen = KeyPairGenerator.getInstance("RSA");
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        if (oldKeyFile != null && oldKeyFile.exists()) {
            this.keys = this.read(null, oldKeyFile, gen);
            this.write(this.keys, keyFile);
            Util.deleteFile((File)oldKeyFile);
        } else {
            KeyPair tempKeys = this.read(keyFile, null, gen);
            if (tempKeys != null) {
                this.keys = tempKeys;
            } else {
                gen.initialize(2048, new SecureRandom());
                this.keys = gen.generateKeyPair();
                this.write(this.keys, keyFile);
            }
        }
    }

    private KeyPair read(File keyFile, File oldKeyFile, KeyPairGenerator gen) throws IOException {
        KeyPair keyPair = null;
        if (keyFile != null) {
            try {
                byte[] enc = Files.readAllBytes(keyFile.toPath());
                keyPair = PEMHelper.decodePEM(new String(this.KEY.decrypt().doFinal(enc), StandardCharsets.UTF_8));
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                LOGGER.fine("identity.key.enc doesn't exist. New Identity.key.enc will be generated");
                return null;
            }
            catch (GeneralSecurityException x) {
                LOGGER.log(Level.SEVERE, "identity.key.enc is corrupted. Identity.key.enc will be deleted and a new one will be generated", x);
                return null;
            }
            catch (IOException | InvalidPathException e) {
                LOGGER.log(Level.SEVERE, "failed to access identity.key.enc. Identity.key.enc will be deleted and a new one will be generated", e);
                return null;
            }
        }
        if (oldKeyFile != null) {
            try {
                keyPair = PEMHelper.decodePEM(Files.readString(oldKeyFile.toPath(), StandardCharsets.UTF_8));
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
        }
        return keyPair;
    }

    private void write(KeyPair keys, File keyFile) throws IOException {
        String pem = PEMHelper.encodePEM(keys);
        try (FileOutputStream os = new FileOutputStream(keyFile);){
            ((OutputStream)os).write(this.KEY.encrypt().doFinal(pem.getBytes(StandardCharsets.UTF_8)));
        }
        InstanceIdentity.makeReadOnly(keyFile);
    }

    private static void makeReadOnly(File keyFile) {
        try {
            new FilePath(keyFile).chmod(384);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to make read only: " + keyFile, e);
        }
    }

    public RSAPublicKey getPublic() {
        return (RSAPublicKey)this.keys.getPublic();
    }

    public RSAPrivateKey getPrivate() {
        return (RSAPrivateKey)this.keys.getPrivate();
    }

    public String getEncodedPublicKey() {
        RSAPublicKey key = this.getPublic();
        return Base64.getEncoder().encodeToString(key.getEncoded());
    }

    public static InstanceIdentity get() {
        PageDecoratorImpl instance = (PageDecoratorImpl)((Object)ExtensionList.lookup(PageDecorator.class).get(PageDecoratorImpl.class));
        if (instance == null) {
            throw new AssertionError((Object)"InstanceIdentity is missing its singleton");
        }
        return instance.identity;
    }

    synchronized X509Certificate getCertificate() {
        if (this.certificate == null || System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L) > this.certificate.getNotAfter().getTime() || System.currentTimeMillis() < this.certificate.getNotBefore().getTime()) {
            try {
                this.certificate = SelfSignedCertificate.forKeyPair(InstanceIdentity.get().keys).cn(Jenkins.getActiveInstance().getLegacyInstanceId()).o("instances").ou("jenkins.io").c("US").validFrom(new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L))).validUntil(new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(366L))).sha256().generate();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to access generate a self-signed identity certificate", e);
                return null;
            }
        }
        return this.certificate;
    }
}

