/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.remoting.protocol.FilterLayer;
import org.jenkinsci.remoting.protocol.impl.ConnectionRefusalException;
import org.jenkinsci.remoting.util.ByteBufferQueue;
import org.jenkinsci.remoting.util.ByteBufferUtils;

public class AckFilterLayer
extends FilterLayer {
    private static final Logger LOGGER = Logger.getLogger(AckFilterLayer.class.getName());
    private final Object recvLock = new Object();
    private final Object sendLock = new Object();
    private final ByteBuffer sendAck;
    private final ByteBuffer recvAck;
    @GuardedBy(value="sendLock")
    private final ByteBufferQueue sendQueue = new ByteBufferQueue(8192);
    @GuardedBy(value="recvLock")
    private final ByteBufferQueue recvQueue = new ByteBufferQueue(8192);
    private boolean receivedAck;
    private volatile boolean aborted;
    @GuardedBy(value="sendLock")
    private Future<?> timeout;

    public AckFilterLayer() {
        this("ACK");
    }

    public AckFilterLayer(String ack) {
        this.sendAck = ByteBufferUtils.wrapUTF8(ack).asReadOnlyBuffer();
        this.recvAck = ByteBuffer.allocate(this.sendAck.capacity());
    }

    private static String toHexString(ByteBuffer buffer) {
        ByteBuffer expectAck = buffer.duplicate();
        ((Buffer)expectAck).position(0);
        ((Buffer)expectAck).limit(buffer.position());
        StringBuilder expectHex = new StringBuilder(expectAck.remaining() * 2);
        while (expectAck.hasRemaining()) {
            int b = expectAck.get() & 0xFF;
            if (b < 16) {
                expectHex.append('0');
            }
            expectHex.append(Integer.toHexString(b));
        }
        return expectHex.toString();
    }

    @SuppressFBWarnings(value={"FORMAT_STRING_MANIPULATION"}, justification="As this converts a String to a Hex string there is little that can be manipulated.")
    private void abort(String type) throws ConnectionRefusalException {
        this.aborted = true;
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "[{0}] {1} acknowledgement sequence, expected 0x{2} got 0x{3}", new Object[]{this.stack().name(), type, AckFilterLayer.toHexString(this.sendAck), AckFilterLayer.toHexString(this.recvAck)});
        }
        ConnectionRefusalException cause = new ConnectionRefusalException(String.format(type + " acknowledgement received, expected 0x%s got 0x%s", AckFilterLayer.toHexString(this.sendAck), AckFilterLayer.toHexString(this.recvAck)));
        this.abort(cause);
        throw cause;
    }

    private boolean receivedAck() {
        if (this.receivedAck) {
            return true;
        }
        ByteBuffer expectAck = this.sendAck.duplicate();
        ByteBuffer actualAck = this.recvAck.duplicate();
        ((Buffer)expectAck).rewind();
        ((Buffer)actualAck).rewind();
        this.receivedAck = expectAck.equals(actualAck);
        return this.receivedAck;
    }

    private boolean receivedPartialAck() {
        if (this.receivedAck) {
            return true;
        }
        ByteBuffer expectAck = this.sendAck.duplicate();
        ByteBuffer actualAck = this.recvAck.duplicate();
        ((Buffer)expectAck).position(0);
        ((Buffer)expectAck).limit(this.sendAck.position());
        ((Buffer)actualAck).position(0);
        ((Buffer)actualAck).limit(this.recvAck.position());
        while (expectAck.hasRemaining() && actualAck.hasRemaining()) {
            byte a;
            byte e = expectAck.get();
            if (e == (a = actualAck.get())) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        Object object = this.sendLock;
        synchronized (object) {
            this.timeout = this.stack().executeLater(() -> {
                IOException cause = new IOException("Timeout waiting for ACK");
                this.abort(cause);
                try {
                    this.doCloseSend();
                    this.onRecvClosed(cause);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }, this.stack().getHandshakingTimeout(), this.stack().getHandshakingUnits());
        }
        try {
            this.doSend(EMPTY_BUFFER);
        }
        catch (ConnectionRefusalException connectionRefusalException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecv(@NonNull ByteBuffer data) throws IOException {
        if (this.aborted) {
            if (!this.sendAck.hasRemaining()) {
                throw new ConnectionRefusalException(String.format("Incorrect acknowledgement received, expected 0x%s got 0x%s", AckFilterLayer.toHexString(this.sendAck), AckFilterLayer.toHexString(this.recvAck)));
            }
            throw new ConnectionRefusalException("Connection closed before acknowledgement send");
        }
        Object object = this.recvLock;
        synchronized (object) {
            if (this.recvAck.hasRemaining()) {
                ByteBufferUtils.put(data, this.recvAck);
                if (this.recvAck.hasRemaining()) {
                    if (!this.receivedPartialAck()) {
                        this.abort("Incorrect");
                    } else if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.log(Level.FINEST, "[{0}] Expecting {1} more bytes of acknowledgement", new Object[]{this.stack().name(), this.recvAck.remaining()});
                    }
                    return;
                }
            }
        }
        if (this.receivedAck()) {
            boolean recvQueueHadRemaining;
            try {
                object = this.sendLock;
                synchronized (object) {
                    if (this.timeout != null) {
                        this.timeout.cancel(false);
                        this.timeout = null;
                    }
                    if (this.sendQueue.hasRemaining()) {
                        this.flushSend(this.sendQueue);
                    }
                }
            }
            catch (IOException e) {
                Object object2 = this.recvLock;
                synchronized (object2) {
                    this.recvQueue.put(data);
                }
                throw e;
            }
            Object object3 = this.recvLock;
            synchronized (object3) {
                recvQueueHadRemaining = this.recvQueue.hasRemaining();
                if (recvQueueHadRemaining) {
                    this.recvQueue.put(data);
                    this.flushRecv(this.recvQueue);
                }
            }
            if (recvQueueHadRemaining) {
                object3 = this.sendLock;
                synchronized (object3) {
                    if (!this.sendQueue.hasRemaining()) {
                        this.complete();
                    }
                }
            } else if (data.hasRemaining()) {
                this.next().onRecv(data);
            }
        } else {
            this.abort("Incorrect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecvClosed(IOException cause) throws IOException {
        IOException rootCause;
        Object object = this.recvLock;
        synchronized (object) {
            if (this.recvAck.hasRemaining() && this.recvAck.position() > 0) {
                super.onRecvClosed(new ConnectionRefusalException(cause, "Partial acknowledgement received, expecting 0x%s got 0x%s", AckFilterLayer.toHexString(this.sendAck), AckFilterLayer.toHexString(this.recvAck)));
                return;
            }
        }
        Object object2 = this.sendLock;
        synchronized (object2) {
            rootCause = this.sendAck.hasRemaining() ? cause : new ConnectionRefusalException("Connection closed before acknowledgement sent");
        }
        object2 = this.recvLock;
        synchronized (object2) {
            super.onRecvClosed(rootCause);
        }
    }

    @Override
    public boolean isRecvOpen() {
        return super.isRecvOpen() && !this.aborted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSend(@NonNull ByteBuffer data) throws IOException {
        if (this.aborted) {
            if (!this.sendAck.hasRemaining()) {
                throw new ConnectionRefusalException(String.format("Incorrect acknowledgement received, expected 0x%s got 0x%s", AckFilterLayer.toHexString(this.sendAck), AckFilterLayer.toHexString(this.recvAck)));
            }
            throw new ConnectionRefusalException("Connection closed before acknowledgement send");
        }
        Object object = this.sendLock;
        synchronized (object) {
            if (this.sendAck.hasRemaining()) {
                this.sendQueue.put(data);
                this.next().doSend(this.sendAck);
                return;
            }
        }
        object = this.recvLock;
        synchronized (object) {
            if (this.recvAck.hasRemaining()) {
                this.sendQueue.put(data);
                return;
            }
        }
        if (this.receivedAck()) {
            object = this.sendLock;
            synchronized (object) {
                if (this.timeout != null) {
                    this.timeout.cancel(false);
                    this.timeout = null;
                }
                if (this.sendQueue.hasRemaining()) {
                    this.sendQueue.put(data);
                    this.flushSend(this.sendQueue);
                } else {
                    try {
                        this.next().doSend(data);
                    }
                    catch (IOException e) {
                        this.sendQueue.put(data);
                        throw e;
                    }
                }
            }
            object = this.recvLock;
            synchronized (object) {
                if (this.recvQueue.hasRemaining()) {
                    this.flushRecv(this.recvQueue);
                }
            }
            this.complete();
        } else {
            this.abort("Incorrect");
        }
    }

    private void complete() {
        if (LOGGER.isLoggable(Level.FINE)) {
            String name = this.stack().name();
            this.completed();
            LOGGER.log(Level.FINE, "[{0}] Acknowledgement exchange completed", name);
        } else {
            this.completed();
        }
    }
}

