/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelClosedException;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.ExportTable;
import hudson.remoting.MultiClassLoaderSerializer;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.ProxyException;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.UserResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.remoting.util.AnonymousClassWarnings;

final class UserRequest<RSP, EXC extends Throwable>
extends Request<ResponseToUserRequest<RSP, EXC>, EXC> {
    private static final Logger LOGGER = Logger.getLogger(UserRequest.class.getName());
    private final byte[] request;
    @NonNull
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="RemoteClassLoader.export() always returns a serializable instance, but we cannot check it statically due to the java.lang.reflect.Proxy")
    private final RemoteClassLoader.IClassLoader classLoaderProxy;
    private final String toString;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="We're fine with default null")
    private final transient ExportTable.ExportList exports;
    private static boolean workaroundDone = false;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRequest(Channel local, Callable<?, EXC> c) throws IOException {
        this.toString = c.toString();
        if (local.isClosingOrClosed()) {
            Exception createdAtValue = this.createdAt;
            if (createdAtValue == null) {
                createdAtValue = new IllegalStateException("Command is created for the channel being interrupted");
            }
            throw new ChannelClosedException(local, "Cannot create UserRequest for channel " + local + ". The channel is closed or being closed.", createdAtValue);
        }
        ClassLoader cl = UserRequest.getClassLoader(c);
        if (cl == null) {
            throw new IOException("Cannot determine classloader for the command " + this.toString);
        }
        this.exports = local.startExportRecording();
        try {
            this.request = this.serialize(c, local);
        }
        finally {
            this.exports.stopRecording();
        }
        this.classLoaderProxy = RemoteClassLoader.export(cl, local);
    }

    @Override
    public void checkIfCanBeExecutedOnChannel(Channel channel) throws IOException {
        super.checkIfCanBeExecutedOnChannel(channel);
        if (channel.isClosingOrClosed()) {
            throw new ChannelClosedException(channel, "The request cannot be executed on channel " + channel + ". The channel is closing down or has closed down", channel.getCloseRequestCause());
        }
    }

    @CheckForNull
    static ClassLoader getClassLoader(@NonNull Callable<?, ?> c) {
        ClassLoader result = null;
        if (c instanceof DelegatingCallable) {
            result = ((DelegatingCallable)c).getClassLoader();
        }
        if (result == null) {
            result = c.getClass().getClassLoader();
        }
        if (result == null) {
            result = ClassLoader.getSystemClassLoader();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected ResponseToUserRequest<RSP, EXC> perform(Channel channel) throws EXC {
        try {
            ResponseToUserRequest responseToUserRequest;
            Object r;
            ClassLoader cl = channel.importedClassLoaders.get(this.classLoaderProxy);
            String clazz = System.getProperty(RemoteClassLoader.class.getName() + ".force", null);
            if (clazz != null && !workaroundDone) {
                String eventMsg = "Loaded";
                Level logLevel = Level.INFO;
                Class<Object> clazz2 = Object.class;
                // MONITORENTER : java.lang.Object.class
                workaroundDone = true;
                try {
                    Class.forName(clazz, true, cl);
                }
                catch (ClassNotFoundException cnfe) {
                    eventMsg = "Couldn't find";
                    logLevel = Level.WARNING;
                }
                Logger logger = Logger.getLogger(RemoteClassLoader.class.getName());
                if (logger.isLoggable(logLevel)) {
                    logger.log(logLevel, "{0} class ''{1}'' using classloader: {2}", new Object[]{eventMsg, clazz, cl.toString()});
                }
            }
            Channel oldc = Channel.setCurrent(channel);
            try {
                Object o;
                try {
                    o = UserRequest.deserialize(channel, this.request, cl);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException("Failed to deserialize the Callable object. Perhaps you needed to implement DelegatingCallable?", e);
                }
                catch (RuntimeException e) {
                    throw new Error("Failed to deserialize the Callable object.", e);
                }
                Callable callable = (Callable)o;
                if (!channel.isArbitraryCallableAllowed() && !(callable instanceof RemoteInvocationHandler.RPCRequest)) {
                    throw new SecurityException("Execution of " + callable.toString() + " is prohibited because the channel is restricted");
                }
                callable = channel.decorators.wrapUserRequest(callable);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    r = callable.call();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            catch (LinkageError e) {
                LOGGER.log(channel.isClosingOrClosed() ? Level.FINE : Level.WARNING, "LinkageError while performing " + this, e);
                throw e;
            }
            finally {
                Channel.setCurrent(oldc);
            }
            byte[] response = this.serialize(r, channel);
            if (channel.remoteCapability.supportsProxyExceptionFallback()) {
                responseToUserRequest = new NormalResponse(response);
                return responseToUserRequest;
            }
            responseToUserRequest = new UserResponse(response, false);
            return responseToUserRequest;
        }
        catch (Throwable e) {
            byte[] response;
            if (channel.remoteCapability.supportsProxyExceptionFallback()) {
                byte[] rawResponse = null;
                try {
                    rawResponse = this._serialize(e, channel);
                }
                catch (NotSerializableException r) {
                    // empty catch block
                }
                byte[] proxyResponse = this.serialize(new ProxyException(e), channel);
                return new ExceptionResponse(rawResponse, proxyResponse);
            }
            try {
                response = this._serialize(e, channel);
                return new UserResponse(response, true);
            }
            catch (NotSerializableException x) {
                response = this.serialize(new ProxyException(e), channel);
            }
            return new UserResponse(response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _serialize(Object o, Channel channel) throws IOException {
        Channel old = Channel.setCurrent(channel);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = channel.remoteCapability.supportsMultiClassLoaderRPC() ? new MultiClassLoaderSerializer.Output(channel, baos) : AnonymousClassWarnings.checkingObjectOutputStream(baos);
            oos.writeObject(o);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    private byte[] serialize(Object o, Channel localChannel) throws IOException {
        try {
            return this._serialize(o, localChannel);
        }
        catch (NotSerializableException e) {
            throw new IOException("Unable to serialize " + o, e);
        }
    }

    @SuppressFBWarnings(value={"OBJECT_DESERIALIZATION"}, justification="Used for sending user requests between authorized agent and server.")
    static Object deserialize(Channel channel, byte[] data, ClassLoader defaultClassLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream ois = channel.remoteCapability.supportsMultiClassLoaderRPC() ? new MultiClassLoaderSerializer.Input(channel, in) : new ObjectInputStreamEx(in, defaultClassLoader, channel.classFilter);
        return ois.readObject();
    }

    public void releaseExports() {
        this.releaseExports(null);
    }

    void releaseExports(Throwable callSite) {
        this.exports.release(callSite);
    }

    @Override
    public String toString() {
        return "UserRequest:" + this.toString;
    }

    private static final class ExceptionResponse<RSP, EXC extends Throwable>
    implements ResponseToUserRequest<RSP, EXC> {
        private static final long serialVersionUID = 1L;
        @CheckForNull
        private final byte[] rawResponse;
        private final byte[] proxyResponse;

        ExceptionResponse(@CheckForNull byte[] rawResponse, byte[] proxyResponse) {
            this.rawResponse = rawResponse;
            this.proxyResponse = proxyResponse;
        }

        @Override
        public RSP retrieve(Channel channel, ClassLoader cl) throws IOException, ClassNotFoundException, EXC {
            Channel old = Channel.setCurrent(channel);
            try {
                Throwable t = null;
                if (this.rawResponse != null) {
                    try {
                        t = (Throwable)UserRequest.deserialize(channel, this.rawResponse, cl);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.FINE, "could not deserialize exception response", x);
                    }
                }
                if (t == null) {
                    t = (Throwable)UserRequest.deserialize(channel, this.proxyResponse, cl);
                }
                channel.attachCallSiteStackTrace(t);
                throw t;
            }
            catch (Throwable throwable) {
                Channel.setCurrent(old);
                throw throwable;
            }
        }
    }

    private static final class NormalResponse<RSP, EXC extends Throwable>
    implements ResponseToUserRequest<RSP, EXC> {
        private static final long serialVersionUID = 1L;
        private final byte[] response;

        NormalResponse(byte[] response) {
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public RSP retrieve(Channel channel, ClassLoader cl) throws IOException, ClassNotFoundException {
            Channel old = Channel.setCurrent(channel);
            try {
                Object object = UserRequest.deserialize(channel, this.response, cl);
                return (RSP)object;
            }
            finally {
                Channel.setCurrent(old);
            }
        }
    }

    static interface ResponseToUserRequest<RSP, EXC extends Throwable>
    extends Serializable {
        public RSP retrieve(Channel var1, ClassLoader var2) throws IOException, ClassNotFoundException, EXC;
    }
}

