/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.CallableDecoratorList;
import hudson.remoting.DelegatingExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class InterceptingExecutorService
extends DelegatingExecutorService {
    private final CallableDecoratorList decorators;

    InterceptingExecutorService(ExecutorService base, CallableDecoratorList decorators) {
        super(base);
        this.decorators = decorators;
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.submit(command);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Callable<T> task) {
        return super.submit(this.wrap(task));
    }

    @Override
    @NonNull
    public Future<?> submit(@NonNull Runnable task) {
        return this.submit(task, null);
    }

    @Override
    @NonNull
    public <T> Future<T> submit(@NonNull Runnable task, T result) {
        return super.submit(this.wrap(task, result));
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks));
    }

    @Override
    @NonNull
    public <T> List<Future<T>> invokeAll(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException {
        return super.invokeAll(this.wrap(tasks), timeout, unit);
    }

    @Override
    @NonNull
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return super.invokeAny(this.wrap(tasks));
    }

    @Override
    public <T> T invokeAny(@NonNull Collection<? extends Callable<T>> tasks, long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return super.invokeAny(this.wrap(tasks), timeout, unit);
    }

    private <V> Callable<V> wrap(Runnable r, V value) {
        return this.wrap(() -> {
            r.run();
            return value;
        });
    }

    private <T> Collection<Callable<T>> wrap(Collection<? extends Callable<T>> callables) {
        ArrayList<Callable<T>> r = new ArrayList<Callable<T>>();
        for (Callable<T> c : callables) {
            r.add(this.wrap(c));
        }
        return r;
    }

    private <V> Callable<V> wrap(Callable<V> r) {
        return this.decorators.wrapCallable(r);
    }
}

