/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Checksum;
import hudson.remoting.FileSystemJarCache;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class InitializeJarCacheMain {
    private static final FilenameFilter JAR_FILE_FILTER = (dir, name) -> name.endsWith(".jar");

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="These file values are provided by users with sufficient administrative permissions to run this utility program.")
    public static void main(String[] argv) throws Exception {
        if (argv.length != 2) {
            throw new IllegalArgumentException("Usage: java -cp agent.jar hudson.remoting.InitializeJarCacheMain <source jar dir> <jar cache dir>");
        }
        File sourceJarDir = new File(argv[0]);
        File jarCacheDir = new File(argv[1]);
        FileSystemJarCache jarCache = new FileSystemJarCache(jarCacheDir, false);
        File[] jars = sourceJarDir.listFiles(JAR_FILE_FILTER);
        if (jars == null) {
            throw new IOException("Cannot list JAR files in " + sourceJarDir);
        }
        for (File jar : jars) {
            Checksum checksum = Checksum.forFile(jar);
            File newJarLocation = jarCache.map(checksum.sum1, checksum.sum2);
            Files.createDirectories(newJarLocation.getParentFile().toPath(), new FileAttribute[0]);
            Files.copy(jar.toPath(), newJarLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

