/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.EngineListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.jenkinsci.remoting.engine.EngineUtil;
import org.jenkinsci.remoting.engine.JnlpProtocol;

class JnlpProtocol1
extends JnlpProtocol {
    static final String NAME = "JNLP-connect";

    JnlpProtocol1(String slaveName, String slaveSecret, EngineListener events) {
        super(slaveName, slaveSecret, events);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    boolean performHandshake(DataOutputStream outputStream, BufferedInputStream inputStream) throws IOException {
        outputStream.writeUTF("Protocol:JNLP-connect");
        outputStream.writeUTF(this.slaveSecret);
        outputStream.writeUTF(this.slaveName);
        String response = EngineUtil.readLine(inputStream);
        if (!response.equals("Welcome")) {
            this.events.status("Server didn't accept the handshake: " + response);
            return false;
        }
        return true;
    }

    @Override
    Channel buildChannel(Socket socket, ChannelBuilder channelBuilder, BufferedInputStream inputStream) throws IOException {
        return channelBuilder.build(inputStream, new BufferedOutputStream(socket.getOutputStream()));
    }
}

