/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.jnlp;

import hudson.remoting.Engine;
import hudson.remoting.EngineListener;
import hudson.remoting.FileSystemJarCache;
import hudson.remoting.jnlp.GuiListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Main {
    @Option(name="-tunnel", metaVar="HOST:PORT", usage="Connect to the specified host and port, instead of connecting directly to Jenkins. Useful when connection to Hudson needs to be tunneled. Can be also HOST: or :PORT, in which case the missing portion will be auto-configured like the default behavior")
    public String tunnel;
    @Option(name="-headless", usage="Run in headless mode, without GUI")
    public boolean headlessMode = Boolean.getBoolean("hudson.agent.headless") || Boolean.getBoolean("hudson.webstart.headless");
    @Option(name="-url", usage="Specify the Jenkins root URLs to connect to.")
    public final List<URL> urls = new ArrayList<URL>();
    @Option(name="-credentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP requests.")
    public String credentials;
    @Option(name="-proxyCredentials", metaVar="USER:PASSWORD", usage="HTTP BASIC AUTH header to pass in for making HTTP authenticated proxy requests.")
    public String proxyCredentials = null;
    @Option(name="-noreconnect", usage="If the connection ends, don't retry and just exit.")
    public boolean noReconnect = false;
    @Option(name="-jar-cache", metaVar="DIR", usage="Cache directory that stores jar files sent from the master")
    public File jarCache = null;
    @Argument
    public final List<String> args = new ArrayList<String>();
    private static final Logger LOGGER = Logger.getLogger(Main.class.getName());

    public static void main(String[] args) throws IOException, InterruptedException {
        try {
            Main._main(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java -jar slave.jar [options...] <secret key> <slave name>");
            new CmdLineParser(new Main()).printUsage(System.err);
        }
    }

    public static void _main(String[] args) throws IOException, InterruptedException, CmdLineException {
        try {
            System.setSecurityManager(null);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        Main m = new Main();
        CmdLineParser p = new CmdLineParser(m);
        p.parseArgument(args);
        if (m.args.size() != 2) {
            throw new CmdLineException("two arguments required, but got " + m.args);
        }
        if (m.urls.isEmpty()) {
            throw new CmdLineException("At least one -url option is required.");
        }
        m.main();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void main() throws IOException, InterruptedException {
        Engine engine = this.createEngine();
        engine.start();
        try {
            engine.join();
            LOGGER.fine("Engine has died");
        }
        finally {
            engine.interrupt();
        }
    }

    public Engine createEngine() {
        String slaveName = this.args.get(1);
        LOGGER.log(Level.INFO, "Setting up slave: {0}", slaveName);
        Engine engine = new Engine(this.headlessMode ? new CuiListener() : new GuiListener(), this.urls, this.args.get(0), slaveName);
        if (this.tunnel != null) {
            engine.setTunnel(this.tunnel);
        }
        if (this.credentials != null) {
            engine.setCredentials(this.credentials);
        }
        if (this.proxyCredentials != null) {
            engine.setProxyCredentials(this.proxyCredentials);
        }
        if (this.jarCache != null) {
            engine.setJarCache(new FileSystemJarCache(this.jarCache, true));
        }
        engine.setNoReconnect(this.noReconnect);
        return engine;
    }

    private static final class CuiListener
    implements EngineListener {
        private CuiListener() {
            LOGGER.info("Jenkins agent is running in headless mode.");
        }

        @Override
        public void status(String msg, Throwable t) {
            LOGGER.log(Level.INFO, msg, t);
        }

        @Override
        public void status(String msg) {
            this.status(msg, null);
        }

        @Override
        public void error(Throwable t) {
            LOGGER.log(Level.SEVERE, t.getMessage(), t);
            System.exit(-1);
        }

        @Override
        public void onDisconnect() {
        }

        @Override
        public void onReconnect() {
        }
    }
}

