/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting.forward;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.SocketChannelStream;
import hudson.remoting.VirtualChannel;
import hudson.remoting.forward.CopyThread;
import hudson.remoting.forward.Forwarder;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleChecker;
import org.jenkinsci.remoting.RoleSensitive;

public class ForwarderFactory {
    public static final Role ROLE = new Role(ForwarderFactory.class);

    public static Forwarder create(VirtualChannel channel, final String remoteHost, final int remotePort) throws IOException, InterruptedException {
        return channel.call(new Callable<Forwarder, IOException>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Forwarder call() throws IOException {
                return new ForwarderImpl(remoteHost, remotePort);
            }

            @Override
            public void checkRoles(RoleChecker checker) throws SecurityException {
                checker.check((RoleSensitive)this, ROLE);
            }
        });
    }

    public static Forwarder create(String remoteHost, int remotePort) {
        return new ForwarderImpl(remoteHost, remotePort);
    }

    private static class ForwarderImpl
    implements Forwarder {
        private final String remoteHost;
        private final int remotePort;
        private static final long serialVersionUID = 8382509901649461466L;

        private ForwarderImpl(String remoteHost, int remotePort) {
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
        }

        @Override
        public OutputStream connect(OutputStream out) throws IOException {
            Socket s = new Socket(this.remoteHost, this.remotePort);
            new CopyThread(String.format("Copier to %s:%d", this.remoteHost, this.remotePort), SocketChannelStream.in(s), out).start();
            return new RemoteOutputStream(SocketChannelStream.out(s));
        }

        private Object writeReplace() {
            return Channel.current().export(Forwarder.class, this);
        }
    }
}

