/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.DelegatingCallable;
import hudson.remoting.ExportTable;
import hudson.remoting.MultiClassLoaderSerializer;
import hudson.remoting.ObjectInputStreamEx;
import hudson.remoting.ProxyException;
import hudson.remoting.RemoteClassLoader;
import hudson.remoting.RemoteInvocationHandler;
import hudson.remoting.Request;
import hudson.remoting.UserResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

final class UserRequest<RSP, EXC extends Throwable>
extends Request<UserResponse<RSP, EXC>, EXC> {
    private final byte[] request;
    private final RemoteClassLoader.IClassLoader classLoaderProxy;
    private final String toString;
    private final transient ExportTable.ExportList exports;
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserRequest(Channel local, Callable<?, EXC> c) throws IOException {
        this.exports = local.startExportRecording();
        try {
            this.request = this.serialize(c, local);
        }
        finally {
            this.exports.stopRecording();
        }
        this.toString = c.toString();
        ClassLoader cl = UserRequest.getClassLoader(c);
        this.classLoaderProxy = RemoteClassLoader.export(cl, local);
    }

    static ClassLoader getClassLoader(Callable<?, ?> c) {
        ClassLoader result = null;
        result = c instanceof DelegatingCallable ? ((DelegatingCallable)c).getClassLoader() : c.getClass().getClassLoader();
        if (result == null) {
            result = ClassLoader.getSystemClassLoader();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected UserResponse<RSP, EXC> perform(Channel channel) throws EXC {
        try {
            ClassLoader cl = channel.importedClassLoaders.get(this.classLoaderProxy);
            Object r = null;
            Channel oldc = Channel.setCurrent(channel);
            try {
                Object o;
                try {
                    o = UserRequest.deserialize(channel, this.request, cl);
                }
                catch (ClassNotFoundException e) {
                    throw new ClassNotFoundException("Failed to deserialize the Callable object. Perhaps you needed to implement DelegatingCallable?", e);
                }
                catch (RuntimeException e) {
                    throw new Error("Failed to deserialize the Callable object.", e);
                }
                Callable callable = (Callable)o;
                if (!channel.isArbitraryCallableAllowed() && !(callable instanceof RemoteInvocationHandler.RPCRequest)) {
                    throw new SecurityException("Execution of " + callable.toString() + " is prohibited because the channel is restricted");
                }
                callable = channel.decorators.wrapUserRequest(callable);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                try {
                    r = callable.call();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            finally {
                Channel.setCurrent(oldc);
            }
            return new UserResponse(this.serialize(r, channel), false);
        }
        catch (Throwable e) {
            byte[] response;
            try {
                response = this._serialize(e, channel);
            }
            catch (NotSerializableException x) {
                response = this.serialize(new ProxyException(e), channel);
            }
            return new UserResponse(response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] _serialize(Object o, Channel channel) throws IOException {
        Channel old = Channel.setCurrent(channel);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = channel.remoteCapability.supportsMultiClassLoaderRPC() ? new MultiClassLoaderSerializer.Output(channel, baos) : new ObjectOutputStream(baos);
            oos.writeObject(o);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Channel.setCurrent(old);
        }
    }

    private byte[] serialize(Object o, Channel localChannel) throws IOException {
        try {
            return this._serialize(o, localChannel);
        }
        catch (NotSerializableException e) {
            IOException x = new IOException("Unable to serialize " + o);
            x.initCause(e);
            throw x;
        }
    }

    static Object deserialize(Channel channel, byte[] data, ClassLoader defaultClassLoader) throws IOException, ClassNotFoundException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ObjectInputStream ois = channel.remoteCapability.supportsMultiClassLoaderRPC() ? new MultiClassLoaderSerializer.Input(channel, in) : new ObjectInputStreamEx(in, defaultClassLoader, channel.classFilter);
        return ois.readObject();
    }

    public void releaseExports() {
        this.releaseExports(null);
    }

    void releaseExports(Throwable callSite) {
        this.exports.release(callSite);
    }

    public String toString() {
        return "UserRequest:" + this.toString;
    }
}

