/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test.recipes;

import java.io.File;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.jvnet.hudson.test.HudsonTestCase;
import org.jvnet.hudson.test.JenkinsRecipe;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.recipes.Recipe;

@Documented
@Recipe(value=RunnerImpl.class)
@JenkinsRecipe(value=RuleRunnerImpl.class)
@Target(value={ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface WithPlugin {
    public String[] value();

    public static class RuleRunnerImpl
    extends JenkinsRecipe.Runner<WithPlugin> {
        private WithPlugin a;

        @Override
        public void setup(JenkinsRule jenkinsRule, WithPlugin recipe) throws Exception {
            this.a = recipe;
            jenkinsRule.useLocalPluginManager = true;
        }

        @Override
        public void decorateHome(JenkinsRule jenkinsRule, File home) throws Exception {
            for (String plugin : this.a.value()) {
                URL res = this.getClass().getClassLoader().getResource("plugins/" + plugin);
                FileUtils.copyURLToFile((URL)res, (File)new File(home, "plugins/" + plugin));
            }
        }
    }

    public static class RunnerImpl
    extends Recipe.Runner<WithPlugin> {
        private WithPlugin a;

        @Override
        public void setup(HudsonTestCase testCase, WithPlugin recipe) throws Exception {
            this.a = recipe;
            testCase.useLocalPluginManager = true;
        }

        @Override
        public void decorateHome(HudsonTestCase testCase, File home) throws Exception {
            for (String plugin : this.a.value()) {
                URL res = this.getClass().getClassLoader().getResource("plugins/" + plugin);
                FileUtils.copyURLToFile((URL)res, (File)new File(home, "plugins/" + plugin));
            }
        }
    }
}

