/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;

public class JenkinsSessionRule
implements TestRule {
    private static final Logger LOGGER = Logger.getLogger(JenkinsSessionRule.class.getName());
    private Description description;
    private final TemporaryDirectoryAllocator tmp = new TemporaryDirectoryAllocator();
    private File home;
    private int port;

    public Statement apply(final Statement base, Description description) {
        this.description = description;
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    JenkinsSessionRule.this.home = JenkinsSessionRule.this.tmp.allocate();
                    base.evaluate();
                }
                finally {
                    try {
                        JenkinsSessionRule.this.tmp.dispose();
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, null, x);
                    }
                }
            }
        };
    }

    public void then(final Step s) throws Throwable {
        final CustomJenkinsRule r = new CustomJenkinsRule(this.home, this.port);
        r.apply(new Statement(){

            public void evaluate() throws Throwable {
                JenkinsSessionRule.this.port = r.getPort();
                s.run(r);
            }
        }, this.description).evaluate();
    }

    private static final class CustomJenkinsRule
    extends JenkinsRule {
        CustomJenkinsRule(File home, int port) {
            this.with(() -> home);
            this.localPort = port;
        }

        int getPort() {
            return this.localPort;
        }
    }

    @FunctionalInterface
    public static interface Step {
        public void run(JenkinsRule var1) throws Throwable;
    }
}

