/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientUtil;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlElementUtil;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import java.io.IOException;
import java.util.List;

public class HtmlFormUtil {
    public static Page submit(HtmlForm htmlForm) throws IOException {
        HtmlElement submitElement = HtmlFormUtil.getSubmitButton(htmlForm);
        return HtmlFormUtil.submit(htmlForm, submitElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Page submit(HtmlForm htmlForm, HtmlElement submitElement) throws IOException {
        HtmlPage htmlPage = (HtmlPage)htmlForm.getPage();
        WebClient webClient = htmlPage.getWebClient();
        try {
            if (submitElement != null && !(submitElement instanceof SubmittableElement)) {
                Page page = submitElement.click();
                return page;
            }
            try {
                htmlForm.submit((SubmittableElement)submitElement);
            }
            catch (Throwable throwable) {
                Page resultPage;
                block11: {
                    webClient.loadDownloadedResponses();
                    resultPage = webClient.getCurrentWindow().getEnclosedPage();
                    if (resultPage != htmlPage) break block11;
                    Page page = HtmlElementUtil.click(submitElement);
                    WebClientUtil.waitForJSExec(webClient);
                    return page;
                }
                Page page = resultPage;
                WebClientUtil.waitForJSExec(webClient);
                return page;
            }
            webClient.loadDownloadedResponses();
            Page resultPage = webClient.getCurrentWindow().getEnclosedPage();
            if (resultPage == htmlPage) {
                Page page = HtmlElementUtil.click(submitElement);
                return page;
            }
            Page page = resultPage;
            return page;
        }
        finally {
            WebClientUtil.waitForJSExec(webClient);
        }
    }

    public static List<HtmlElement> getSubmitButtons(HtmlForm htmlForm) throws ElementNotFoundException {
        List list = htmlForm.getElementsByAttribute("input", "type", "submit");
        for (HtmlElement elt : htmlForm.getLostChildren()) {
            list.add(elt);
        }
        return list;
    }

    public static HtmlElement getSubmitButton(HtmlForm htmlForm) throws ElementNotFoundException {
        List<HtmlElement> submitButtons = HtmlFormUtil.getSubmitButtons(htmlForm);
        if (!submitButtons.isEmpty()) {
            return submitButtons.get(0);
        }
        for (HtmlElement element : htmlForm.getElementsByTagName("button")) {
            if (!(element instanceof HtmlButton)) continue;
            return element;
        }
        return null;
    }

    public static HtmlButton getButtonByCaption(HtmlForm htmlForm, String caption) throws ElementNotFoundException {
        for (HtmlElement b : htmlForm.getElementsByTagName("button")) {
            if (!(b instanceof HtmlButton) || !b.getTextContent().trim().equals(caption)) continue;
            return (HtmlButton)b;
        }
        throw new ElementNotFoundException("button", "caption", caption);
    }
}

