/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.plugins.gradle.Gradle;
import hudson.plugins.gradle.GradleInstallation;
import hudson.tasks.Ant;
import hudson.tasks.Maven;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public class ToolInstallations {
    private static final Logger LOGGER = Logger.getLogger(ToolInstallations.class.getName());

    public static Maven.MavenInstallation configureDefaultMaven() throws Exception {
        return ToolInstallations.configureDefaultMaven("apache-maven-2.2.1", 0);
    }

    public static Maven.MavenInstallation configureMaven3() throws Exception {
        Maven.MavenInstallation mvn = ToolInstallations.configureDefaultMaven("apache-maven-3.0.1", 2);
        Maven.MavenInstallation m3 = new Maven.MavenInstallation("apache-maven-3.0.1", mvn.getHome(), JenkinsRule.NO_PROPERTIES);
        ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{m3});
        return m3;
    }

    public static Maven.MavenInstallation configureMaven35() throws Exception {
        Maven.MavenInstallation mvn = ToolInstallations.configureDefaultMaven("apache-maven-3.5.0", 2);
        Maven.MavenInstallation maven350 = new Maven.MavenInstallation("apache-maven-3.5.0", mvn.getHome(), JenkinsRule.NO_PROPERTIES);
        ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{maven350});
        return maven350;
    }

    public static Maven.MavenInstallation configureDefaultMaven(String mavenVersion, int mavenReqVersion) throws Exception {
        Maven.MavenInstallation mavenInstallation;
        File buildDirectory = new File(System.getProperty("buildDirectory", "target"));
        File mvnHome = new File(buildDirectory, mavenVersion);
        if (mvnHome.exists()) {
            Maven.MavenInstallation mavenInstallation2 = new Maven.MavenInstallation("default", mvnHome.getAbsolutePath(), JenkinsRule.NO_PROPERTIES);
            ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation2});
            return mavenInstallation2;
        }
        String home = System.getProperty("maven.home");
        if (home != null && (mavenInstallation = new Maven.MavenInstallation("default", home, JenkinsRule.NO_PROPERTIES)).meetsMavenReqVersion((Launcher)new Launcher.LocalLauncher((TaskListener)StreamTaskListener.fromStdout()), mavenReqVersion)) {
            ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation});
            return mavenInstallation;
        }
        LOGGER.log(Level.WARNING, "Extracting a copy of Maven bundled in the test harness into {0}. To avoid a performance hit, set the system property ''maven.home'' to point to a Maven2 installation.", mvnHome);
        FilePath mvn = Jenkins.getInstance().getRootPath().createTempFile("maven", "zip");
        mvn.copyFrom(JenkinsRule.class.getClassLoader().getResource(mavenVersion + "-bin.zip"));
        mvn.unzip(new FilePath(buildDirectory));
        try {
            GNUCLibrary.LIBC.chmod(new File(mvnHome, "bin/mvn").getPath(), 493);
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        Maven.MavenInstallation mavenInstallation3 = new Maven.MavenInstallation("default", mvnHome.getAbsolutePath(), JenkinsRule.NO_PROPERTIES);
        ((Maven.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Maven.DescriptorImpl.class)).setInstallations(new Maven.MavenInstallation[]{mavenInstallation3});
        return mavenInstallation3;
    }

    public static Ant.AntInstallation configureDefaultAnt(TemporaryFolder tmp) throws Exception {
        Ant.AntInstallation antInstallation;
        if (System.getenv("ANT_HOME") != null) {
            antInstallation = new Ant.AntInstallation("default", System.getenv("ANT_HOME"), JenkinsRule.NO_PROPERTIES);
        } else {
            LOGGER.warning("Extracting a copy of Ant bundled in the test harness. To avoid a performance hit, set the environment variable ANT_HOME to point to an  Ant installation.");
            FilePath ant = Jenkins.getInstance().getRootPath().createTempFile("ant", "zip");
            ant.copyFrom(JenkinsRule.class.getClassLoader().getResource("apache-ant-1.8.1-bin.zip"));
            File antHome = tmp.newFolder("antHome");
            ant.unzip(new FilePath(antHome));
            try {
                GNUCLibrary.LIBC.chmod(new File(antHome, "apache-ant-1.8.1/bin/ant").getPath(), 493);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            antInstallation = new Ant.AntInstallation("default", new File(antHome, "apache-ant-1.8.1").getAbsolutePath(), JenkinsRule.NO_PROPERTIES);
        }
        ((Ant.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Ant.DescriptorImpl.class)).setInstallations(new Ant.AntInstallation[]{antInstallation});
        return antInstallation;
    }

    public static GradleInstallation configureDefaultGradle(TemporaryFolder tmp) throws Exception {
        GradleInstallation installation;
        if (System.getenv("GRADLE_HOME") != null) {
            installation = new GradleInstallation("default", System.getenv("GRADLE_HOME"), JenkinsRule.NO_PROPERTIES);
        } else {
            LOGGER.warning("Extracting a copy of Gradle bundled in the test harness. To avoid a performance hit, set the environment variable GRADLE_HOME to point to a Gradle installation.");
            FilePath gradle = Jenkins.getInstance().getRootPath().createTempFile("gradle", "zip");
            gradle.copyFrom(JenkinsRule.class.getClassLoader().getResource("gradle-2.13-bin.zip"));
            File gradleHome = tmp.newFolder("gradleHome");
            gradle.unzip(new FilePath(gradleHome));
            try {
                GNUCLibrary.LIBC.chmod(new File(gradleHome, "gradle-2.13/bin/gradle").getPath(), 493);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            installation = new GradleInstallation("default", new File(gradleHome, "gradle-2.13").getAbsolutePath(), JenkinsRule.NO_PROPERTIES);
        }
        ((Gradle.DescriptorImpl)Jenkins.getInstance().getDescriptorByType(Gradle.DescriptorImpl.class)).setInstallations(new GradleInstallation[]{installation});
        return installation;
    }

    private ToolInstallations() {
    }
}

