/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.glassfish.tyrus.core;

import io.jenkins.cli.shaded.javax.websocket.Decoder;
import io.jenkins.cli.shaded.javax.websocket.MessageHandler;
import io.jenkins.cli.shaded.javax.websocket.PongMessage;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.AnnotatedEndpoint;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.AsyncMessageHandler;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.BasicMessageHandler;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.ReflectionHelper;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.coder.CoderWrapper;
import io.jenkins.cli.shaded.org.glassfish.tyrus.core.l10n.LocalizationMessages;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageHandlerManager {
    private static final List<Class<?>> WHOLE_TEXT_HANDLER_TYPES = Arrays.asList(String.class, Reader.class);
    private static final Class<?> PARTIAL_TEXT_HANDLER_TYPE = String.class;
    private static final List<Class<?>> WHOLE_BINARY_HANDLER_TYPES = Arrays.asList(ByteBuffer.class, InputStream.class, byte[].class);
    private static final List<Class<?>> PARTIAL_BINARY_HANDLER_TYPES = Arrays.asList(ByteBuffer.class, byte[].class);
    private static final Class<?> PONG_HANDLER_TYPE = PongMessage.class;
    private boolean textHandlerPresent;
    private boolean textWholeHandlerPresent;
    private boolean binaryHandlerPresent;
    private boolean binaryWholeHandlerPresent;
    private boolean pongHandlerPresent;
    private boolean readerHandlerPresent;
    private boolean inputStreamHandlerPresent;
    private final Map<Class<?>, MessageHandler> registeredHandlers = new HashMap();
    private final List<Class<? extends Decoder>> decoders;
    private Set<MessageHandler> messageHandlerCache;

    public MessageHandlerManager() {
        this(Collections.emptyList());
    }

    MessageHandlerManager(List<Class<? extends Decoder>> decoders) {
        this.decoders = decoders;
    }

    static MessageHandlerManager fromDecoderInstances(List<Decoder> decoders) {
        ArrayList<Class<? extends Decoder>> decoderList = new ArrayList<Class<? extends Decoder>>();
        for (Decoder decoder : decoders) {
            if (decoder instanceof CoderWrapper) {
                decoderList.add(((CoderWrapper)decoder).getCoderClass());
                continue;
            }
            decoderList.add(decoder.getClass());
        }
        return new MessageHandlerManager(decoderList);
    }

    public static MessageHandlerManager fromDecoderClasses(List<Class<? extends Decoder>> decoderClasses) {
        return new MessageHandlerManager(decoderClasses);
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        Class<?> handlerClass = MessageHandlerManager.getHandlerType(handler);
        if (handler instanceof MessageHandler.Whole) {
            this.addMessageHandler(handlerClass, (MessageHandler.Whole)handler);
        } else if (handler instanceof MessageHandler.Partial) {
            this.addMessageHandler(handlerClass, (MessageHandler.Partial)handler);
        } else {
            this.throwException(LocalizationMessages.MESSAGE_HANDLER_WHOLE_OR_PARTIAL());
        }
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> handler) throws IllegalStateException {
        if (WHOLE_TEXT_HANDLER_TYPES.contains(clazz)) {
            if (this.textHandlerPresent) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_TEXT());
            } else {
                if (Reader.class.isAssignableFrom(clazz)) {
                    this.readerHandlerPresent = true;
                }
                this.textHandlerPresent = true;
                this.textWholeHandlerPresent = true;
            }
        } else if (WHOLE_BINARY_HANDLER_TYPES.contains(clazz)) {
            if (this.binaryHandlerPresent) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_BINARY());
            } else {
                if (InputStream.class.isAssignableFrom(clazz)) {
                    this.inputStreamHandlerPresent = true;
                }
                this.binaryHandlerPresent = true;
                this.binaryWholeHandlerPresent = true;
            }
        } else if (PONG_HANDLER_TYPE.equals(clazz)) {
            if (this.pongHandlerPresent) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_PONG());
            } else {
                this.pongHandlerPresent = true;
            }
        } else {
            boolean viable = false;
            if (this.checkTextDecoders(clazz)) {
                if (this.textHandlerPresent) {
                    this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_TEXT());
                } else {
                    this.textHandlerPresent = true;
                    this.textWholeHandlerPresent = true;
                    viable = true;
                }
            }
            if (this.checkBinaryDecoders(clazz)) {
                if (this.binaryHandlerPresent) {
                    this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_BINARY());
                } else {
                    this.binaryHandlerPresent = true;
                    this.binaryWholeHandlerPresent = true;
                    viable = true;
                }
            }
            if (!viable) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_DECODER_NOT_REGISTERED(clazz));
            }
        }
        this.registerMessageHandler(clazz, handler);
    }

    public <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> handler) throws IllegalStateException {
        boolean viable = false;
        if (PARTIAL_TEXT_HANDLER_TYPE.equals(clazz)) {
            if (this.textHandlerPresent) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_TEXT());
            } else {
                this.textHandlerPresent = true;
                viable = true;
            }
        }
        if (PARTIAL_BINARY_HANDLER_TYPES.contains(clazz)) {
            if (this.binaryHandlerPresent) {
                this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_BINARY());
            } else {
                this.binaryHandlerPresent = true;
                viable = true;
            }
        }
        if (!viable) {
            this.throwException(LocalizationMessages.MESSAGE_HANDLER_PARTIAL_INVALID_TYPE(clazz.getName()));
        }
        this.registerMessageHandler(clazz, handler);
    }

    private <T> void registerMessageHandler(Class<T> clazz, MessageHandler handler) {
        if (this.registeredHandlers.containsKey(clazz)) {
            this.throwException(LocalizationMessages.MESSAGE_HANDLER_ALREADY_REGISTERED_TYPE(clazz));
        } else {
            this.registeredHandlers.put(clazz, handler);
        }
        this.messageHandlerCache = null;
    }

    private void throwException(String text) throws IllegalStateException {
        throw new IllegalStateException(text);
    }

    public void removeMessageHandler(MessageHandler handler) {
        Iterator<Map.Entry<Class<?>, MessageHandler>> iterator = this.registeredHandlers.entrySet().iterator();
        Class<?> handlerClass = null;
        while (iterator.hasNext()) {
            Map.Entry<Class<?>, MessageHandler> next = iterator.next();
            if (!next.getValue().equals(handler)) continue;
            handlerClass = next.getKey();
            iterator.remove();
            this.messageHandlerCache = null;
            break;
        }
        if (handlerClass == null) {
            return;
        }
        if (handler instanceof MessageHandler.Whole) {
            if (WHOLE_TEXT_HANDLER_TYPES.contains(handlerClass)) {
                this.textHandlerPresent = false;
                this.textWholeHandlerPresent = false;
            } else if (WHOLE_BINARY_HANDLER_TYPES.contains(handlerClass)) {
                this.binaryHandlerPresent = false;
                this.binaryWholeHandlerPresent = false;
            } else if (PONG_HANDLER_TYPE.equals(handlerClass)) {
                this.pongHandlerPresent = false;
            } else if (this.checkTextDecoders(handlerClass)) {
                this.textHandlerPresent = false;
                this.textWholeHandlerPresent = false;
            } else if (this.checkBinaryDecoders(handlerClass)) {
                this.binaryHandlerPresent = false;
                this.binaryWholeHandlerPresent = false;
            }
        } else if (PARTIAL_TEXT_HANDLER_TYPE.equals(handlerClass)) {
            this.textHandlerPresent = false;
        } else if (PARTIAL_BINARY_HANDLER_TYPES.contains(handlerClass)) {
            this.binaryHandlerPresent = false;
        }
    }

    public Set<MessageHandler> getMessageHandlers() {
        if (this.messageHandlerCache == null) {
            this.messageHandlerCache = Collections.unmodifiableSet(new HashSet<MessageHandler>(this.registeredHandlers.values()));
        }
        return this.messageHandlerCache;
    }

    public List<Map.Entry<Class<?>, MessageHandler>> getOrderedWholeMessageHandlers() {
        ArrayList result = new ArrayList();
        for (Map.Entry<Class<?>, MessageHandler> entry : this.registeredHandlers.entrySet()) {
            if (!(entry.getValue() instanceof MessageHandler.Whole)) continue;
            result.add(entry);
        }
        Collections.sort(result, new MessageHandlerComparator());
        return result;
    }

    static Class<?> getHandlerType(MessageHandler handler) {
        Class root;
        if (handler instanceof AsyncMessageHandler) {
            return ((AsyncMessageHandler)handler).getType();
        }
        if (handler instanceof BasicMessageHandler) {
            return ((BasicMessageHandler)handler).getType();
        }
        if (handler instanceof MessageHandler.Partial) {
            root = MessageHandler.Partial.class;
        } else if (handler instanceof MessageHandler.Whole) {
            root = MessageHandler.Whole.class;
        } else {
            throw new IllegalArgumentException(LocalizationMessages.MESSAGE_HANDLER_ILLEGAL_ARGUMENT(handler));
        }
        Class<?> result = ReflectionHelper.getClassType(handler.getClass(), root);
        return result == null ? Object.class : result;
    }

    private boolean checkTextDecoders(Class<?> requiredType) {
        for (Class<? extends Decoder> decoderClass : this.decoders) {
            if (!this.isTextDecoder(decoderClass) || !requiredType.isAssignableFrom(AnnotatedEndpoint.getDecoderClassType(decoderClass))) continue;
            return true;
        }
        return false;
    }

    private boolean checkBinaryDecoders(Class<?> requiredType) {
        for (Class<? extends Decoder> decoderClass : this.decoders) {
            if (!this.isBinaryDecoder(decoderClass) || !requiredType.isAssignableFrom(AnnotatedEndpoint.getDecoderClassType(decoderClass))) continue;
            return true;
        }
        return false;
    }

    private boolean isTextDecoder(Class<? extends Decoder> decoderClass) {
        return Decoder.Text.class.isAssignableFrom(decoderClass) || Decoder.TextStream.class.isAssignableFrom(decoderClass);
    }

    private boolean isBinaryDecoder(Class<? extends Decoder> decoderClass) {
        return Decoder.Binary.class.isAssignableFrom(decoderClass) || Decoder.BinaryStream.class.isAssignableFrom(decoderClass);
    }

    boolean isWholeTextHandlerPresent() {
        return this.textWholeHandlerPresent;
    }

    boolean isWholeBinaryHandlerPresent() {
        return this.binaryWholeHandlerPresent;
    }

    boolean isPartialTextHandlerPresent() {
        return this.textHandlerPresent && !this.textWholeHandlerPresent;
    }

    boolean isPartialBinaryHandlerPresent() {
        return this.binaryHandlerPresent && !this.binaryWholeHandlerPresent;
    }

    public boolean isReaderHandlerPresent() {
        return this.readerHandlerPresent;
    }

    public boolean isInputStreamHandlerPresent() {
        return this.inputStreamHandlerPresent;
    }

    boolean isPongHandlerPresent() {
        return this.pongHandlerPresent;
    }

    private static class MessageHandlerComparator
    implements Comparator<Map.Entry<Class<?>, MessageHandler>>,
    Serializable {
        private static final long serialVersionUID = -5136634876439146784L;

        private MessageHandlerComparator() {
        }

        @Override
        public int compare(Map.Entry<Class<?>, MessageHandler> o1, Map.Entry<Class<?>, MessageHandler> o2) {
            if (o1.getKey().isAssignableFrom(o2.getKey())) {
                return 1;
            }
            if (o2.getKey().isAssignableFrom(o1.getKey())) {
                return -1;
            }
            return 0;
        }
    }
}

