/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.server.keyprovider;

import io.jenkins.cli.shaded.org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.spec.InvalidKeySpecException;

public class SimpleGeneratorHostKeyProvider
extends AbstractGeneratorHostKeyProvider {
    public SimpleGeneratorHostKeyProvider() {
    }

    public SimpleGeneratorHostKeyProvider(File file) {
        this(file == null ? null : file.toPath());
    }

    public SimpleGeneratorHostKeyProvider(Path path) {
        this.setPath(path);
    }

    @Override
    protected KeyPair doReadKeyPair(String resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
        Throwable throwable = null;
        try (ObjectInputStream r = new ObjectInputStream(inputStream);){
            KeyPair keyPair = (KeyPair)r.readObject();
            return keyPair;
        }
        catch (ClassNotFoundException e) {
            try {
                throw new InvalidKeySpecException("Missing classes: " + e.getMessage(), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    protected void doWriteKeyPair(String resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
        try (ObjectOutputStream w = new ObjectOutputStream(outputStream);){
            w.writeObject(kp);
        }
    }
}

