/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.cipher.ECCurves;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.Buffer;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.buffer.keys.AbstractBufferPublicKeyParser;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

public class ECBufferPublicKeyParser
extends AbstractBufferPublicKeyParser<ECPublicKey> {
    public static final ECBufferPublicKeyParser INSTANCE = new ECBufferPublicKeyParser();

    public ECBufferPublicKeyParser() {
        super(ECPublicKey.class, ECCurves.KEY_TYPES);
    }

    @Override
    public ECPublicKey getRawPublicKey(String keyType, Buffer buffer) throws GeneralSecurityException {
        ValidateUtils.checkTrue(this.isKeyTypeSupported(keyType), "Unsupported key type: %s", (Object)keyType);
        ECCurves curve = ECCurves.fromKeyType(keyType);
        if (curve == null) {
            throw new NoSuchAlgorithmException("Unsupported raw public algorithm: " + keyType);
        }
        String curveName = curve.getName();
        ECParameterSpec params = curve.getParameters();
        return this.getRawECKey(curveName, params, buffer);
    }

    protected ECPublicKey getRawECKey(String expectedCurve, ECParameterSpec spec, Buffer buffer) throws GeneralSecurityException {
        ECPoint w;
        String curveName = buffer.getString();
        if (!expectedCurve.equals(curveName)) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ") curve name does not match expected: " + curveName);
        }
        if (spec == null) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ") missing curve parameters");
        }
        byte[] octets = buffer.getBytes();
        try {
            w = ECCurves.octetStringToEcPoint(octets);
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("getRawECKey(" + expectedCurve + ") cannot (" + e.getClass().getSimpleName() + ") retrieve W value: " + e.getMessage(), e);
        }
        return (ECPublicKey)this.generatePublicKey("EC", new ECPublicKeySpec(w, spec));
    }
}

