/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.impl;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.IdentityResourceLoader;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.logging.AbstractLoggingBean;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Objects;

public abstract class AbstractIdentityResourceLoader<PUB extends PublicKey, PRV extends PrivateKey>
extends AbstractLoggingBean
implements IdentityResourceLoader<PUB, PRV> {
    private final Class<PUB> pubType;
    private final Class<PRV> prvType;
    private final Collection<String> names;

    protected AbstractIdentityResourceLoader(Class<PUB> pubType, Class<PRV> prvType, Collection<String> names) {
        this.pubType = Objects.requireNonNull(pubType, "No public key type specified");
        this.prvType = Objects.requireNonNull(prvType, "No private key type specified");
        this.names = ValidateUtils.checkNotNullAndNotEmpty(names, "No type names provided", new Object[0]);
    }

    @Override
    public final Class<PUB> getPublicKeyType() {
        return this.pubType;
    }

    @Override
    public final Class<PRV> getPrivateKeyType() {
        return this.prvType;
    }

    @Override
    public Collection<String> getSupportedTypeNames() {
        return this.names;
    }
}

