/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.common.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.IdentityUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.KeyUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.GenericUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.NumberUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class PublicKeyEntry
implements Serializable {
    public static final char COMMENT_CHAR = '#';
    public static final String STD_KEYFILE_FOLDER_NAME = ".ssh";
    private static final long serialVersionUID = -585506072687602760L;
    private String keyType;
    private byte[] keyData;

    public PublicKeyEntry() {
    }

    public PublicKeyEntry(String keyType, byte ... keyData) {
        this.keyType = keyType;
        this.keyData = keyData;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String value) {
        this.keyType = value;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    public void setKeyData(byte[] value) {
        this.keyData = value;
    }

    public PublicKey resolvePublicKey(PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        String kt = this.getKeyType();
        PublicKeyEntryResolver decoder = KeyUtils.getPublicKeyEntryDecoder(kt);
        if (decoder == null) {
            decoder = fallbackResolver;
        }
        if (decoder == null) {
            throw new InvalidKeySpecException("No decoder available for key type=" + kt);
        }
        return decoder.resolve(kt, this.getKeyData());
    }

    public PublicKey appendPublicKey(Appendable sb, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        PublicKey key = this.resolvePublicKey(fallbackResolver);
        if (key != null) {
            PublicKeyEntry.appendPublicKeyEntry(sb, key);
        }
        return key;
    }

    public int hashCode() {
        return Objects.hashCode(this.getKeyType()) + Arrays.hashCode(this.getKeyData());
    }

    protected boolean isEquivalent(PublicKeyEntry e) {
        if (this == e) {
            return true;
        }
        return Objects.equals(this.getKeyType(), e.getKeyType()) && Arrays.equals(this.getKeyData(), e.getKeyData());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.isEquivalent((PublicKeyEntry)obj);
    }

    public String toString() {
        byte[] data = this.getKeyData();
        Base64.Encoder encoder = Base64.getEncoder();
        return this.getKeyType() + " " + (NumberUtils.isEmpty(data) ? "<no-key>" : encoder.encodeToString(data));
    }

    public static PublicKeyEntry parsePublicKeyEntry(String encData) throws IllegalArgumentException {
        String data = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data)) {
            return null;
        }
        return PublicKeyEntry.parsePublicKeyEntry(new PublicKeyEntry(), data);
    }

    public static <E extends PublicKeyEntry> E parsePublicKeyEntry(E entry, String encData) throws IllegalArgumentException {
        String data = GenericUtils.replaceWhitespaceAndTrim(encData);
        if (GenericUtils.isEmpty(data) || entry == null) {
            return entry;
        }
        int startPos = data.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + data);
        }
        int endPos = data.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = data.length();
        }
        String keyType = data.substring(0, startPos);
        String b64Data = data.substring(startPos + 1, endPos).trim();
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] keyData = decoder.decode(b64Data);
        if (NumberUtils.isEmpty(keyData)) {
            throw new IllegalArgumentException("Bad format (no BASE64 key data): " + data);
        }
        entry.setKeyType(keyType);
        entry.setKeyData(keyData);
        return entry;
    }

    public static String toString(PublicKey key) throws IllegalArgumentException {
        try {
            return PublicKeyEntry.appendPublicKeyEntry(new StringBuilder(127), key).toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed (" + e.getClass().getSimpleName() + ") to encode: " + e.getMessage(), e);
        }
    }

    public static <A extends Appendable> A appendPublicKeyEntry(A sb, PublicKey key) throws IOException {
        if (key == null) {
            return sb;
        }
        PublicKeyEntryDecoder<?, ?> decoder = KeyUtils.getPublicKeyEntryDecoder(key);
        if (decoder == null) {
            throw new StreamCorruptedException("Cannot retrieve decoder for key=" + key.getAlgorithm());
        }
        try (ByteArrayOutputStream s = new ByteArrayOutputStream(127);){
            String keyType = decoder.encodePublicKey(s, key);
            byte[] bytes = s.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            String b64Data = encoder.encodeToString(bytes);
            sb.append(keyType).append(' ').append(b64Data);
        }
        return sb;
    }

    public static Path getDefaultKeysFolderPath() {
        return LazyDefaultKeysFolderHolder.PATH;
    }

    private static final class LazyDefaultKeysFolderHolder {
        private static final Path PATH = IdentityUtils.getUserHomeFolder().resolve(".ssh");

        private LazyDefaultKeysFolderHolder() {
        }
    }
}

