/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.cli.shaded.org.apache.sshd.client.config.keys;

import io.jenkins.cli.shaded.org.apache.sshd.common.config.keys.FilePasswordProvider;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.ValidateUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.io.IoUtils;
import io.jenkins.cli.shaded.org.apache.sshd.common.util.security.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;

public interface ClientIdentityLoader {
    public static final ClientIdentityLoader DEFAULT = new ClientIdentityLoader(){

        @Override
        public boolean isValidLocation(String location) throws IOException {
            Path path = this.toPath(location);
            return Files.exists(path, IoUtils.EMPTY_LINK_OPTIONS);
        }

        @Override
        public KeyPair loadClientIdentity(String location, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            Path path = this.toPath(location);
            try (InputStream inputStream = Files.newInputStream(path, IoUtils.EMPTY_OPEN_OPTIONS);){
                KeyPair keyPair = SecurityUtils.loadKeyPairIdentity(path.toString(), inputStream, provider);
                return keyPair;
            }
        }

        public String toString() {
            return "DEFAULT";
        }

        private Path toPath(String location) {
            Path path = Paths.get(ValidateUtils.checkNotNullAndNotEmpty(location, "No location"), new String[0]);
            path = path.toAbsolutePath();
            path = path.normalize();
            return path;
        }
    };

    public boolean isValidLocation(String var1) throws IOException;

    public KeyPair loadClientIdentity(String var1, FilePasswordProvider var2) throws IOException, GeneralSecurityException;
}

