/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datasource.toolkit;

import com.jeeplus.database.datasource.exception.ErrorCreateDataSourceException;
import com.jeeplus.database.datasource.toolkit.Base64;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class CryptoUtils {
    public static final String DEFAULT_PUBLIC_KEY_STRING = "MFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBAJ4o6sn4WoPmbs7DR9mGQzuuUQM9erQTVPpwxIzB0ETYkyKffO097qXVRLA6KPmaV+/siWewR7vpfYYjWajw5KkCAwEAAQ==";
    private static final String ALLATORIxDEMO = "MIIBVAIBADANBgkqhkiG9w0BAQEFAASCAT4wggE6AgEAAkEAnijqyfhag+ZuzsNH2YZDO65RAz16tBNU+nDEjMHQRNiTIp987T3updVEsDoo+ZpX7+yJZ7BHu+l9hiNZqPDkqQIDAQABAkBgErbczRIewWFaE+GXTymUHUV01Gmu7XdXUhzy6+CZkIcEnyTpUgPilGUydiIyeiY8usvWKGjFWxLoKeJDY1wBAiEA5M9uqc9XpL5uitLWHiiq7pRxhnJb/B+wZyHqLVhCLekCIQCw9D/Fsx7vHRgymWYExHvCka7w5SyWUmNzQOOKjZUIwQIhAMqbo7JaF5GZzui+qTsrZ7C7YYtb2Hf414t7TJG6hV+BAiBXuZ7r+fL6A+h9HUNQVcAtI2AhGNxT4aBgAOlNRQd/gQIgCGqaZsOdnL9624SI1DwhBt4x24q3350pWwzgfl4Kbbo=";

    public static String encrypt(String a, String a2) throws Exception {
        if (a == null) {
            a = ALLATORIxDEMO;
        }
        return CryptoUtils.encrypt(Base64.base64ToByteArray(a), a2);
    }

    public static String encrypt(String a) throws Exception {
        return CryptoUtils.encrypt((String)null, a);
    }

    public static String decrypt(String a) throws Exception {
        return CryptoUtils.decrypt((String)null, a);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey getPublicKeyByPublicKeyFile(String a) {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream;
        if (a == null) return CryptoUtils.getPublicKey(null);
        if (a.length() == 0) {
            return CryptoUtils.getPublicKey(null);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(a);
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            byte[] byArray = new byte[64];
            FileInputStream fileInputStream2 = fileInputStream;
            while ((n = fileInputStream2.read(byArray)) != -1) {
                fileInputStream2 = fileInputStream;
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (Exception exception) {
            try {
                throw new IllegalArgumentException(ErrorCreateDataSourceException.ALLATORIxDEMO("O4`9l1)!fun0}uy k9`6)>l,"), exception);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        {
            object = byteArrayOutputStream.toByteArray();
            object = new X509EncodedKeySpec((byte[])object);
            object = KeyFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"), ErrorCreateDataSourceException.ALLATORIxDEMO("Z g\u0007z4Z<n;")).generatePublic((KeySpec)object);
            if (fileInputStream == null) return object;
        }
        try {
            fileInputStream.close();
            return object;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return object;
    }

    public static String[] genKeyPair(int a) {
        String[] stringArray;
        byte[][] byArray = CryptoUtils.genKeyPairBytes(a);
        String[] stringArray2 = stringArray = new String[2];
        stringArray2[0] = Base64.byteArrayToBase64(byArray[0]);
        stringArray[1] = Base64.byteArrayToBase64(byArray[1]);
        return stringArray2;
    }

    public static PublicKey getPublicKey(String a) {
        if (a == null || a.length() == 0) {
            a = DEFAULT_PUBLIC_KEY_STRING;
        }
        try {
            byte[] byArray = Base64.base64ToByteArray(a);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return KeyFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"), ErrorCreateDataSourceException.ALLATORIxDEMO("Z g\u0007z4Z<n;")).generatePublic(x509EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(ErrorCreateDataSourceException.ALLATORIxDEMO("O4`9l1)!fun0}uy k9`6)>l,"), exception);
        }
    }

    public static String decrypt(String a, String a2) throws Exception {
        return CryptoUtils.decrypt(CryptoUtils.getPublicKey(a), a2);
    }

    public static String decrypt(PublicKey a, String a2) throws Exception {
        Object object;
        String string;
        Cipher cipher = Cipher.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("[\u0006HzL\u0016KzY\u001eJ\u00068\u0005h1m<g2"));
        try {
            cipher.init(2, a);
            string = a2;
        }
        catch (InvalidKeyException invalidKeyException) {
            object = (RSAPublicKey)a;
            Object object2 = new RSAPrivateKeySpec(object.getModulus(), object.getPublicExponent());
            object2 = KeyFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014")).generatePrivate((KeySpec)object2);
            cipher = Cipher.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"));
            string = a2;
            cipher.init(2, (Key)object2);
        }
        if (string == null || a2.length() == 0) {
            return a2;
        }
        byte[] byArray = Base64.base64ToByteArray(a2);
        object = cipher.doFinal(byArray);
        return new String((byte[])object);
    }

    public static String encrypt(byte[] a, String a2) throws Exception {
        Cipher cipher;
        Object object = new PKCS8EncodedKeySpec(a);
        object = KeyFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"), ErrorCreateDataSourceException.ALLATORIxDEMO("Z g\u0007z4Z<n;")).generatePrivate((KeySpec)object);
        Cipher cipher2 = Cipher.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("[\u0006HzL\u0016KzY\u001eJ\u00068\u0005h1m<g2"));
        try {
            cipher2.init(1, (Key)object);
            cipher = cipher2;
        }
        catch (InvalidKeyException invalidKeyException) {
            object = (RSAPrivateKey)object;
            object = new RSAPublicKeySpec(object.getModulus(), object.getPrivateExponent());
            object = KeyFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014")).generatePublic((KeySpec)object);
            cipher = cipher2 = Cipher.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"));
            cipher2.init(1, (Key)object);
        }
        return Base64.byteArrayToBase64(cipher.doFinal(a2.getBytes("UTF-8")));
    }

    public static byte[][] genKeyPairBytes(int a) {
        byte[][] byArrayArray = new byte[2][];
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\u0007Z\u0014"), ErrorCreateDataSourceException.ALLATORIxDEMO("Z g\u0007z4Z<n;"));
            keyPairGenerator.initialize(a, new SecureRandom());
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            byArrayArray[0] = keyPair.getPrivate().getEncoded();
            byArrayArray[1] = keyPair.getPublic().getEncoded();
            return byArrayArray;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            generalSecurityException.printStackTrace();
            return byArrayArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PublicKey getPublicKeyByX509(String a) {
        PublicKey publicKey;
        if (a == null) return CryptoUtils.getPublicKey(null);
        if (a.length() == 0) {
            return CryptoUtils.getPublicKey(null);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(a);
            CertificateFactory certificateFactory = CertificateFactory.getInstance(ErrorCreateDataSourceException.ALLATORIxDEMO("\r'`9l"));
            publicKey = certificateFactory.generateCertificate(fileInputStream).getPublicKey();
            if (fileInputStream == null) return publicKey;
        }
        catch (Exception exception) {
            try {
                throw new IllegalArgumentException(ErrorCreateDataSourceException.ALLATORIxDEMO("O4`9l1)!fun0}uy k9`6)>l,"), exception);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                        throwable2 = throwable;
                        throw throwable2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throwable2 = throwable;
                throw throwable2;
            }
        }
        try {
            fileInputStream.close();
            return publicKey;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return publicKey;
    }

    public CryptoUtils() {
        CryptoUtils a;
    }
}

