/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datasource.spring.boot.autoconfigure;

import com.jeeplus.database.datasource.DynamicDataSourceConfigure;
import com.jeeplus.database.datasource.DynamicDataSourceCreator;
import com.jeeplus.database.datasource.DynamicRoutingDataSource;
import com.jeeplus.database.datasource.aop.DynamicDataSourceAdvisor;
import com.jeeplus.database.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.jeeplus.database.datasource.aop.DynamicDataSourceAnnotationInterceptor;
import com.jeeplus.database.datasource.processor.DsHeaderProcessor;
import com.jeeplus.database.datasource.processor.DsProcessor;
import com.jeeplus.database.datasource.processor.DsSessionProcessor;
import com.jeeplus.database.datasource.processor.DsSpelExpressionProcessor;
import com.jeeplus.database.datasource.provider.DynamicDataSourceProvider;
import com.jeeplus.database.datasource.provider.YmlDynamicDataSourceProvider;
import com.jeeplus.database.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.jeeplus.database.datasource.spring.boot.autoconfigure.druid.DruidDynamicDataSourceConfiguration;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={DynamicDataSourceProperties.class})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={DruidDynamicDataSourceConfiguration.class})
public class DynamicDataSourceAutoConfiguration {
    @Autowired
    private DynamicDataSourceProperties L;
    private static final Logger d = LoggerFactory.getLogger(DynamicDataSourceAutoConfiguration.class);
    @Autowired
    private DatabaseIdProvider ALLATORIxDEMO;

    @Bean
    @ConditionalOnMissingBean
    public DsProcessor dsProcessor() {
        DsHeaderProcessor dsHeaderProcessor = new DsHeaderProcessor();
        DsSessionProcessor dsSessionProcessor = new DsSessionProcessor();
        DsSpelExpressionProcessor dsSpelExpressionProcessor = new DsSpelExpressionProcessor();
        DsHeaderProcessor dsHeaderProcessor2 = dsHeaderProcessor;
        dsHeaderProcessor2.setNextProcessor(dsSessionProcessor);
        dsSessionProcessor.setNextProcessor(dsSpelExpressionProcessor);
        return dsHeaderProcessor2;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        DynamicDataSourceAutoConfiguration a;
        return new YmlDynamicDataSourceProvider(a.L);
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceAnnotationAdvisor dynamicDatasourceAnnotationAdvisor(DsProcessor a) {
        DynamicDataSourceAutoConfiguration a2;
        DynamicDataSourceAnnotationInterceptor dynamicDataSourceAnnotationInterceptor = new DynamicDataSourceAnnotationInterceptor();
        dynamicDataSourceAnnotationInterceptor.setDsProcessor(a);
        DynamicDataSourceAnnotationAdvisor dynamicDataSourceAnnotationAdvisor = new DynamicDataSourceAnnotationAdvisor(dynamicDataSourceAnnotationInterceptor);
        dynamicDataSourceAnnotationAdvisor.setOrder(a2.L.getOrder());
        return dynamicDataSourceAnnotationAdvisor;
    }

    @Bean
    @ConditionalOnBean(value={DynamicDataSourceConfigure.class})
    public DynamicDataSourceAdvisor dynamicAdvisor(DynamicDataSourceConfigure a, DsProcessor a2) {
        Object object = a = new DynamicDataSourceAdvisor(((DynamicDataSourceConfigure)a).getMatchers());
        ((DynamicDataSourceAdvisor)((Object)object)).setDsProcessor(a2);
        object.setOrder(Integer.MIN_VALUE);
        return object;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicDataSourceCreator dynamicDataSourceCreator() {
        DynamicDataSourceAutoConfiguration a;
        DynamicDataSourceCreator dynamicDataSourceCreator;
        DynamicDataSourceCreator dynamicDataSourceCreator2 = dynamicDataSourceCreator = new DynamicDataSourceCreator();
        DynamicDataSourceAutoConfiguration dynamicDataSourceAutoConfiguration = a;
        dynamicDataSourceCreator.setDruidGlobalConfig(dynamicDataSourceAutoConfiguration.L.getDruid());
        dynamicDataSourceCreator2.setHikariGlobalConfig(dynamicDataSourceAutoConfiguration.L.getHikari());
        dynamicDataSourceCreator2.setGlobalPublicKey(a.L.getPublicKey());
        return dynamicDataSourceCreator2;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSource dataSource(DynamicDataSourceProvider a) {
        DynamicDataSourceAutoConfiguration a2;
        DynamicRoutingDataSource dynamicRoutingDataSource;
        DynamicRoutingDataSource dynamicRoutingDataSource2 = dynamicRoutingDataSource = new DynamicRoutingDataSource();
        DynamicDataSourceAutoConfiguration dynamicDataSourceAutoConfiguration = a2;
        DynamicRoutingDataSource dynamicRoutingDataSource3 = dynamicRoutingDataSource;
        DynamicDataSourceAutoConfiguration dynamicDataSourceAutoConfiguration2 = a2;
        dynamicRoutingDataSource.setPrimary(dynamicDataSourceAutoConfiguration2.L.getPrimary());
        dynamicRoutingDataSource3.setStrategy(dynamicDataSourceAutoConfiguration2.L.getStrategy());
        dynamicRoutingDataSource3.setProvider(a);
        dynamicRoutingDataSource.setDatabaseIdProvider(dynamicDataSourceAutoConfiguration.ALLATORIxDEMO);
        dynamicRoutingDataSource2.setP6spy(dynamicDataSourceAutoConfiguration.L.getP6spy());
        dynamicRoutingDataSource2.setStrict(a2.L.getStrict());
        return dynamicRoutingDataSource2;
    }

    public DynamicDataSourceAutoConfiguration() {
        DynamicDataSourceAutoConfiguration a;
    }
}

