/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.database.datasource.plugin;

import com.jeeplus.database.datasource.toolkit.DynamicDataSourceContextHolder;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MasterSlaveAutoRoutingPlugin
implements Interceptor {
    private static final Logger L = LoggerFactory.getLogger(MasterSlaveAutoRoutingPlugin.class);
    private static final String d = "master";
    private static final String ALLATORIxDEMO = "slave";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation a) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)a.getArgs()[0];
        try {
            DynamicDataSourceContextHolder.push(SqlCommandType.SELECT == mappedStatement.getSqlCommandType() ? ALLATORIxDEMO : d);
            a = a.proceed();
            return a;
        }
        finally {
            DynamicDataSourceContextHolder.clear();
        }
    }

    public Object plugin(Object a) {
        if (a instanceof Executor) {
            MasterSlaveAutoRoutingPlugin a2;
            return Plugin.wrap((Object)a, (Interceptor)a2);
        }
        return a;
    }

    public void setProperties(Properties a) {
    }

    public MasterSlaveAutoRoutingPlugin() {
        MasterSlaveAutoRoutingPlugin a;
    }
}

